/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.style.book.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.style.book.model.StyleBookEntry"}, service={StagedModelRepository.class})
public class StylebookEntryStagedModelRepository
implements StagedModelRepository<StyleBookEntry> {
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;

    public StyleBookEntry addStagedModel(PortletDataContext portletDataContext, StyleBookEntry styleBookEntry) throws PortalException {
        long userId = portletDataContext.getUserId(styleBookEntry.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)styleBookEntry);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(styleBookEntry.getUuid());
        }
        return this._styleBookEntryLocalService.addStyleBookEntry(userId, styleBookEntry.getGroupId(), styleBookEntry.getFrontendTokensValues(), styleBookEntry.getName(), styleBookEntry.getStyleBookEntryKey(), serviceContext);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        StyleBookEntry styleBookEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (styleBookEntry != null) {
            this.deleteStagedModel(styleBookEntry);
        }
    }

    public void deleteStagedModel(StyleBookEntry styleBookEntry) throws PortalException {
        this._styleBookEntryLocalService.deleteStyleBookEntry(styleBookEntry);
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public StyleBookEntry fetchMissingReference(String uuid, long groupId) {
        return (StyleBookEntry)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public StyleBookEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._styleBookEntryLocalService.fetchStyleBookEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<StyleBookEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._styleBookEntryLocalService.getStyleBookEntriesByUuidAndCompanyId(uuid, companyId);
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._styleBookEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public StyleBookEntry getStagedModel(long classPK) throws PortalException {
        return this._styleBookEntryLocalService.getStyleBookEntry(classPK);
    }

    public StyleBookEntry saveStagedModel(StyleBookEntry styleBookEntry) throws PortalException {
        return this._styleBookEntryLocalService.updateStyleBookEntry(styleBookEntry);
    }

    public StyleBookEntry updateStagedModel(PortletDataContext portletDataContext, StyleBookEntry styleBookEntry) throws PortalException {
        return this._styleBookEntryLocalService.updateStyleBookEntry(portletDataContext.getUserId(styleBookEntry.getUserUuid()), styleBookEntry.getStyleBookEntryId(), styleBookEntry.isDefaultStyleBookEntry(), styleBookEntry.getFrontendTokensValues(), styleBookEntry.getName(), styleBookEntry.getStyleBookEntryKey(), styleBookEntry.getPreviewFileEntryId());
    }
}

