/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.base.SubscriptionLocalServiceBaseImpl;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.subscription.model.Subscription"}, service={AopService.class})
public class SubscriptionLocalServiceImpl
extends SubscriptionLocalServiceBaseImpl {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Subscription addSubscription(long userId, long groupId, String className, long classPK) throws PortalException {
        return this.addSubscription(userId, groupId, className, classPK, "instant");
    }

    public Subscription addSubscription(long userId, long groupId, String className, long classPK, String frequency) throws PortalException {
        AssetEntry assetEntry;
        User user = this._userLocalService.getUser(userId);
        long classNameId = this._classNameLocalService.getClassNameId(className);
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(user.getCompanyId(), userId, classNameId, classPK);
        if (subscription == null) {
            long subscriptionId = this.counterLocalService.increment();
            subscription = this.subscriptionPersistence.create(subscriptionId);
            subscription.setGroupId(groupId);
            subscription.setCompanyId(user.getCompanyId());
            subscription.setUserId(user.getUserId());
            subscription.setUserName(user.getFullName());
            subscription.setClassNameId(classNameId);
            subscription.setClassPK(classPK);
            subscription.setFrequency(frequency);
            subscription = (Subscription)this.subscriptionPersistence.update((BaseModel)subscription);
        }
        if (groupId > 0L && (assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK)) != null) {
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)assetEntry.getTitle());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)assetEntry, (int)10002, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return subscription;
    }

    public void deleteGroupSubscriptions(long groupId) {
        this.subscriptionPersistence.removeByGroupId(groupId);
    }

    @Override
    public Subscription deleteSubscription(long subscriptionId) throws PortalException {
        Subscription subscription = this.subscriptionPersistence.findByPrimaryKey(subscriptionId);
        return this.deleteSubscription(subscription);
    }

    public void deleteSubscription(long userId, String className, long classPK) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(user.getCompanyId(), userId, this._classNameLocalService.getClassNameId(className), classPK);
        if (subscription != null) {
            this.deleteSubscription(subscription);
        }
    }

    @Override
    @SystemEvent(type=1)
    public Subscription deleteSubscription(Subscription subscription) throws PortalException {
        this.subscriptionPersistence.remove((BaseModel)subscription);
        ClassName className = this._classNameLocalService.getClassName(subscription.getClassNameId());
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className.getClassName(), subscription.getClassPK());
        if (assetEntry != null) {
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)assetEntry.getTitle());
            SocialActivityManagerUtil.addActivity((long)subscription.getUserId(), (ClassedModel)subscription, (int)10003, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return subscription;
    }

    public void deleteSubscriptions(long userId) throws PortalException {
        List subscriptions = this.subscriptionPersistence.findByUserId(userId);
        for (Subscription subscription : subscriptions) {
            this.deleteSubscription(subscription);
        }
    }

    public void deleteSubscriptions(long userId, long groupId) throws PortalException {
        List subscriptions = this.subscriptionPersistence.findByG_U(groupId, userId);
        for (Subscription subscription : subscriptions) {
            this.deleteSubscription(subscription);
        }
    }

    public void deleteSubscriptions(long companyId, String className, long classPK) throws PortalException {
        List subscriptions = this.subscriptionPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
        for (Subscription subscription : subscriptions) {
            this.deleteSubscription(subscription);
        }
    }

    public Subscription fetchSubscription(long companyId, long userId, String className, long classPK) {
        return this.subscriptionPersistence.fetchByC_U_C_C(companyId, userId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public Subscription getSubscription(long companyId, long userId, String className, long classPK) throws PortalException {
        return this.subscriptionPersistence.findByC_U_C_C(companyId, userId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<Subscription> getSubscriptions(long companyId, long userId, String className, long[] classPKs) {
        return this.subscriptionPersistence.findByC_U_C_C(companyId, userId, this._classNameLocalService.getClassNameId(className), classPKs);
    }

    public List<Subscription> getSubscriptions(long companyId, String className, long classPK) {
        return this.subscriptionPersistence.findByC_C_C(companyId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    @Deprecated
    public List<Subscription> getSubscriptions(String className) {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)this._classNameLocalService.getClassNameId(className)));
        return this.dynamicQuery(dynamicQuery);
    }

    @Deprecated
    public int getSubscriptionsCount(String className) {
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
        dynamicQuery.add(classNameIdProperty.eq((Object)this._classNameLocalService.getClassNameId(className)));
        Long count = this.dynamicQueryCount(dynamicQuery);
        return count.intValue();
    }

    public List<Subscription> getUserSubscriptions(long userId, int start, int end, OrderByComparator<Subscription> orderByComparator) {
        return this.subscriptionPersistence.findByUserId(userId, start, end, orderByComparator);
    }

    public List<Subscription> getUserSubscriptions(long userId, String className) {
        return this.subscriptionPersistence.findByU_C(userId, this._classNameLocalService.getClassNameId(className));
    }

    public int getUserSubscriptionsCount(long userId) {
        return this.subscriptionPersistence.countByUserId(userId);
    }

    public boolean isSubscribed(long companyId, long userId, String className, long classPK) {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        if (this.subscriptionPersistence.countByU_C(userId, classNameId) == 0) {
            return false;
        }
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(companyId, userId, classNameId, classPK);
        return subscription != null;
    }

    public boolean isSubscribed(long companyId, long userId, String className, long[] classPKs) {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        if (this.subscriptionPersistence.countByU_C(userId, classNameId) == 0) {
            return false;
        }
        int count = this.subscriptionPersistence.countByC_U_C_C(companyId, userId, classNameId, classPKs);
        return count > 0;
    }
}

