/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.translator;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.translation.translator.TranslatorPacket;
import java.util.LinkedHashMap;
import java.util.Map;

public class JSONTranslatorPacket
implements TranslatorPacket {
    private final long _companyId;
    private final Map<String, String> _fieldsMap = new LinkedHashMap<String, String>();
    private final Map<String, Boolean> _htmlMap = new LinkedHashMap<String, Boolean>();
    private final String _sourceLanguageId;
    private final String _targetLanguageId;

    @Deprecated
    public JSONTranslatorPacket(JSONObject jsonObject) {
        this(CompanyThreadLocal.getCompanyId(), jsonObject);
    }

    public JSONTranslatorPacket(long companyId, JSONObject jsonObject) {
        this._companyId = companyId;
        this._sourceLanguageId = jsonObject.getString("sourceLanguageId");
        this._targetLanguageId = jsonObject.getString("targetLanguageId");
        JSONObject fieldsJSONObject = jsonObject.getJSONObject("fields");
        JSONObject htmlJSONObject = jsonObject.getJSONObject("html");
        for (String key : fieldsJSONObject.keySet()) {
            this._fieldsMap.put(key, fieldsJSONObject.getString(key));
            this._htmlMap.put(key, this._getHtml(key, htmlJSONObject));
        }
    }

    @Override
    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public Map<String, String> getFieldsMap() {
        return this._fieldsMap;
    }

    @Override
    public Map<String, Boolean> getHTMLMap() {
        return this._htmlMap;
    }

    @Override
    public String getSourceLanguageId() {
        return this._sourceLanguageId;
    }

    @Override
    public String getTargetLanguageId() {
        return this._targetLanguageId;
    }

    private Boolean _getHtml(String key, JSONObject htmlJSONObject) {
        if (htmlJSONObject == null) {
            return null;
        }
        return htmlJSONObject.getBoolean(key);
    }
}

