/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.translator;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.translation.translator.TranslatorPacket;
import java.util.LinkedHashMap;
import java.util.Map;

public class JSONTranslatorPacket
implements TranslatorPacket {
    private final Map<String, String> _fieldsMap = new LinkedHashMap<String, String>();
    private final String _sourceLanguageId;
    private final String _targetLanguageId;

    public JSONTranslatorPacket(JSONObject jsonObject) {
        this._sourceLanguageId = jsonObject.getString("sourceLanguageId");
        this._targetLanguageId = jsonObject.getString("targetLanguageId");
        JSONObject fieldsJSONObject = jsonObject.getJSONObject("fields");
        for (String key : fieldsJSONObject.keySet()) {
            this._fieldsMap.put(key, fieldsJSONObject.getString(key));
        }
    }

    @Override
    public Map<String, String> getFieldsMap() {
        return this._fieldsMap;
    }

    @Override
    public String getSourceLanguageId() {
        return this._sourceLanguageId;
    }

    @Override
    public String getTargetLanguageId() {
        return this._targetLanguageId;
    }
}

