/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.exporter;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.translation.exporter.TranslationInfoItemFieldValuesExporter;
import com.liferay.translation.info.field.TranslationInfoFieldChecker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.type=application/xliff+xml"}, service={TranslationInfoItemFieldValuesExporter.class})
public class XLIFF20InfoFormTranslationExporter
implements TranslationInfoItemFieldValuesExporter {
    @Reference
    private TranslationInfoFieldChecker _translationInfoFieldChecker;

    public InputStream exportInfoItemFieldValues(InfoItemFieldValues infoItemFieldValues, Locale sourceLocale, Locale targetLocale) throws IOException {
        Document document = SAXReaderUtil.createDocument();
        Element xliffElement = document.addElement("xliff", "urn:oasis:names:tc:xliff:document:2.0");
        xliffElement.addAttribute("srcLang", LocaleUtil.toBCP47LanguageId((Locale)sourceLocale));
        xliffElement.addAttribute("trgLang", LocaleUtil.toBCP47LanguageId((Locale)targetLocale));
        xliffElement.addAttribute("version", "2.0");
        Element fileElement = xliffElement.addElement("file");
        InfoItemReference infoItemReference = infoItemFieldValues.getInfoItemReference();
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return null;
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
        fileElement.addAttribute("id", infoItemReference.getClassName() + ":" + classPKInfoItemIdentifier.getClassPK());
        LinkedHashMap<String, List> infoFieldValuesMap = new LinkedHashMap<String, List>();
        for (InfoFieldValue infoFieldValue : infoItemFieldValues.getInfoFieldValues()) {
            InfoField infoField = infoFieldValue.getInfoField();
            if (!this._translationInfoFieldChecker.isTranslatable(infoField)) continue;
            List infoFieldValuesList = infoFieldValuesMap.computeIfAbsent(infoField.getUniqueId(), uniqueId -> new ArrayList());
            infoFieldValuesList.add(infoFieldValue);
        }
        for (Map.Entry entry : infoFieldValuesMap.entrySet()) {
            Element unitElement = fileElement.addElement("unit");
            unitElement.addAttribute("id", (String)entry.getKey());
            for (InfoFieldValue infoFieldValue : (List)entry.getValue()) {
                this._addInfoFieldValue((InfoFieldValue<Object>)infoFieldValue, unitElement, sourceLocale, targetLocale);
            }
        }
        String formattedString = document.formattedString();
        return new ByteArrayInputStream(formattedString.getBytes());
    }

    public String getMimeType() {
        return "application/xliff+xml";
    }

    private void _addInfoFieldValue(InfoFieldValue<Object> infoFieldValue, Element unitElement, Locale sourceLocale, Locale targetLocale) {
        Element segmentElement = unitElement.addElement("segment");
        Element sourceElement = segmentElement.addElement("source");
        sourceElement.addCDATA(this._getStringValue(infoFieldValue.getValue(sourceLocale)));
        Element targetElement = segmentElement.addElement("target");
        targetElement.addCDATA(this._getStringValue(infoFieldValue.getValue(targetLocale)));
    }

    private String _getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

