/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.snapshot;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.translation.exception.XLIFFFileException;
import com.liferay.translation.internal.util.XLIFFLocaleIdUtil;
import com.liferay.translation.snapshot.TranslationSnapshot;
import com.liferay.translation.snapshot.TranslationSnapshotProvider;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.autoxliff.AutoXLIFFFilter;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.type=application/xliff+xml"}, service={TranslationSnapshotProvider.class})
public class XLIFFTranslationSnapshotProvider
implements TranslationSnapshotProvider {
    private static final Pattern _pattern = Pattern.compile("([^:]+):(.+)");
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    /*
     * Enabled aggressive exception aggregation
     */
    public TranslationSnapshot getTranslationSnapshot(long groupId, InfoItemReference infoItemReference, InputStream inputStream, boolean includeSource) throws IOException, XLIFFFileException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)XLIFFTranslationSnapshotProvider.class.getClassLoader());){
            LocaleId targetLocaleId;
            LocaleId sourceLocaleId;
            ArrayList<Event> events;
            AutoXLIFFFilter autoXLIFFFilter;
            block19: {
                TranslationSnapshot translationSnapshot;
                autoXLIFFFilter = new AutoXLIFFFilter();
                try {
                    events = new ArrayList<Event>();
                    File tempFile = FileUtil.createTempFile((InputStream)inputStream);
                    Document document = SAXReaderUtil.read((File)tempFile);
                    sourceLocaleId = XLIFFLocaleIdUtil.getSourceLocaleId(document);
                    targetLocaleId = XLIFFLocaleIdUtil.getTargetLocaleId(document);
                    autoXLIFFFilter.open(new RawDocument(tempFile.toURI(), document.getXMLEncoding(), sourceLocaleId, targetLocaleId));
                    while (autoXLIFFFilter.hasNext()) {
                        events.add(autoXLIFFFilter.next());
                    }
                    if (!this._isVersion20(events)) break block19;
                    translationSnapshot = new TranslationSnapshot(this._getInfoItemFieldValuesXLIFFv20(groupId, infoItemReference, tempFile, includeSource), LocaleUtil.fromLanguageId((String)sourceLocaleId.toString()), LocaleUtil.fromLanguageId((String)targetLocaleId.toString()));
                }
                catch (Throwable throwable) {
                    try {
                        autoXLIFFFilter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                autoXLIFFFilter.close();
                return translationSnapshot;
            }
            TranslationSnapshot translationSnapshot = new TranslationSnapshot(this._getInfoItemFieldValuesXLIFFv12(events, infoItemReference, includeSource), LocaleUtil.fromLanguageId((String)sourceLocaleId.toString()), LocaleUtil.fromLanguageId((String)targetLocaleId.toString()));
            autoXLIFFFilter.close();
            return translationSnapshot;
        }
        catch (OkapiIllegalFilterOperationException | XLIFFException exception) {
            if (exception.getCause() instanceof CharConversionException) {
                throw new XLIFFFileException.MustHaveCorrectEncoding(exception);
            }
            throw new XLIFFFileException.MustBeValid(exception);
        }
        catch (DocumentException documentException) {
            throw new XLIFFFileException.MustHaveCorrectEncoding((Throwable)documentException);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new XLIFFFileException.MustHaveValidParameter((Throwable)invalidParameterException);
        }
    }

    private InfoField _createInfoField(Locale locale, String value) {
        String[] namespaceAndNameArray = this._getNamespaceAndNameArray(value);
        return InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(namespaceAndNameArray[0]).name(namespaceAndNameArray[1]).labelInfoLocalizedValue(InfoLocalizedValue.builder().value(locale, (Object)value).build()).localizable(true).build();
    }

    private InfoItemFieldValues _getInfoItemFieldValuesXLIFFv12(List<Event> events, InfoItemReference infoItemReference, boolean includeSource) throws XLIFFFileException {
        this._validateDocumentPartVersion(events);
        StartSubDocument startSubDocument = this._getStartSubdocument(events);
        this._validateXLIFFStartSubdocument(infoItemReference, startSubDocument);
        Locale sourceLocale = this._getSourceLocale(startSubDocument);
        Locale targetLocale = this._getTargetLocale(startSubDocument);
        return InfoItemFieldValues.builder().infoFieldValue(unsafeConsumer -> this._produceInfoFieldValuesXLIFFv12((UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException>)unsafeConsumer, events, sourceLocale, targetLocale, includeSource)).infoItemReference(this._getInfoItemReference(events)).build();
    }

    private InfoItemFieldValues _getInfoItemFieldValuesXLIFFv20(long groupId, InfoItemReference infoItemReference, File tempFile, boolean includeSource) throws XLIFFFileException {
        XLIFFDocument xliffDocument = new XLIFFDocument();
        xliffDocument.load(tempFile);
        this._validateXLIFFFile(groupId, infoItemReference, xliffDocument);
        StartXliffData startXliffData = xliffDocument.getStartXliffData();
        Locale sourceLocale = LocaleUtil.fromLanguageId((String)startXliffData.getSourceLanguage(), (boolean)true, (boolean)false);
        Locale targetLocale = LocaleUtil.fromLanguageId((String)startXliffData.getTargetLanguage(), (boolean)true, (boolean)false);
        return InfoItemFieldValues.builder().infoFieldValue(unsafeConsumer -> this._produceInfoFieldValuesXLIFFv20((UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException>)unsafeConsumer, xliffDocument, sourceLocale, targetLocale, includeSource)).infoItemReference(this._getInfoItemReference(xliffDocument)).build();
    }

    private InfoItemReference _getInfoItemReference(List<Event> events) throws XLIFFFileException {
        Event eventStartSubdocument = null;
        for (Event event : events) {
            if (!event.isStartSubDocument()) continue;
            eventStartSubdocument = event;
        }
        if (eventStartSubdocument == null) {
            throw new XLIFFFileException.MustBeWellFormed("The XLIFF file is not well formed");
        }
        StartSubDocument startSubDocument = eventStartSubdocument.getStartSubDocument();
        Matcher matcher = _pattern.matcher(startSubDocument.getName());
        if (!matcher.matches()) {
            throw new XLIFFFileException.MustBeWellFormed("The XLIFF file is not well formed");
        }
        return new InfoItemReference(matcher.group(1), GetterUtil.getLong((String)matcher.group(2)));
    }

    private InfoItemReference _getInfoItemReference(XLIFFDocument xliffDocument) throws XLIFFFileException {
        List fileNodeIds = xliffDocument.getFileNodeIds();
        Matcher matcher = _pattern.matcher((CharSequence)fileNodeIds.get(0));
        if (!matcher.matches()) {
            throw new XLIFFFileException.MustBeWellFormed("The XLIFF file is not well formed");
        }
        return new InfoItemReference(matcher.group(1), GetterUtil.getLong((String)matcher.group(2)));
    }

    private String[] _getNamespaceAndNameArray(String value) {
        String[] parts = value.split("_", 2);
        if (parts.length != 2) {
            return new String[]{"", value};
        }
        return parts;
    }

    private long _getSegmentsExperienceClassPK(InfoItemReference infoItemReference) {
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return 0L;
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
        if (!Objects.equals(infoItemReference.getClassName(), Layout.class.getName())) {
            return classPKInfoItemIdentifier.getClassPK();
        }
        Layout layout = this._layoutLocalService.fetchLayout(classPKInfoItemIdentifier.getClassPK());
        if (layout == null || !layout.isDraftLayout()) {
            return classPKInfoItemIdentifier.getClassPK();
        }
        return layout.getClassPK();
    }

    private Locale _getSourceLocale(StartSubDocument startSubDocument) {
        Property sourceLanguageProperty = startSubDocument.getProperty("sourceLanguage");
        if (sourceLanguageProperty == null || sourceLanguageProperty.getValue() == null) {
            return null;
        }
        return LocaleUtil.fromLanguageId((String)sourceLanguageProperty.getValue());
    }

    private StartSubDocument _getStartSubdocument(List<Event> events) {
        for (Event event : events) {
            if (!event.isStartSubDocument()) continue;
            return event.getStartSubDocument();
        }
        return null;
    }

    private Locale _getTargetLocale(StartSubDocument startSubDocument) {
        Property targetLanguageProperty = startSubDocument.getProperty("targetLanguage");
        if (targetLanguageProperty == null || targetLanguageProperty.getValue() == null) {
            return null;
        }
        return LocaleUtil.fromLanguageId((String)targetLanguageProperty.getValue());
    }

    private boolean _isVersion20(List<Event> events) {
        for (Event event : events) {
            double version;
            StartDocument startDocument;
            Property versionProperty;
            if (!event.isStartDocument() || (versionProperty = (startDocument = event.getStartDocument()).getProperty("version")) == null || !((version = GetterUtil.getDouble((String)versionProperty.getValue())) >= 2.0) || !(version < 3.0)) continue;
            return true;
        }
        return false;
    }

    private void _produceInfoFieldValuesXLIFFv12(UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException> unsafeConsumer, List<Event> events, Locale sourceLocale, Locale targetLocale, boolean includeSource) throws XLIFFFileException {
        for (Event event : events) {
            if (!event.isTextUnit()) continue;
            ITextUnit iTextUnit = event.getTextUnit();
            this._validateWellFormedTextUnit(targetLocale, iTextUnit);
            TextContainer sourceTextContainer = iTextUnit.getSource();
            for (LocaleId targetLocaleId : iTextUnit.getTargetLocales()) {
                TextContainer targetTextContainer = iTextUnit.getTarget(targetLocaleId);
                for (TextPart targetTextPart : targetTextContainer.getParts()) {
                    TextFragment targetTextFragment = targetTextPart.getContent();
                    if (Validator.isNull((String)targetTextFragment.getText())) continue;
                    unsafeConsumer.accept((Object)new InfoFieldValue(this._createInfoField(targetLocale, iTextUnit.getId()), (Object)InfoLocalizedValue.builder().value(targetLocale, (Object)targetTextFragment.toText()).value(biConsumer -> {
                        if (includeSource) {
                            TextFragment sourceTextFragment = sourceTextContainer.getFirstContent();
                            biConsumer.accept((Object)sourceLocale, (Object)sourceTextFragment.toText());
                        }
                    }).build()));
                }
            }
        }
    }

    private void _produceInfoFieldValuesXLIFFv20(UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException> unsafeConsumer, XLIFFDocument xliffDocument, Locale sourceLocale, Locale targetLocale, boolean includeSource) throws XLIFFFileException {
        for (Unit unit : xliffDocument.getUnits()) {
            for (int i = 0; i < unit.getPartCount(); ++i) {
                Part part = unit.getPart(i);
                Fragment targetFragment = part.getTarget();
                if (targetFragment == null) {
                    throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
                }
                unsafeConsumer.accept((Object)new InfoFieldValue(this._createInfoField(targetLocale, unit.getId()), (Object)InfoLocalizedValue.builder().value(targetLocale, (Object)targetFragment.getPlainText()).value(biConsumer -> {
                    if (includeSource) {
                        Fragment sourceFragment = part.getSource();
                        biConsumer.accept((Object)sourceLocale, (Object)sourceFragment.getPlainText());
                    }
                }).build()));
            }
        }
    }

    private void _validateDocumentPartVersion(List<Event> events) throws XLIFFFileException.MustBeValid {
        for (Event event : events) {
            DocumentPart documentPart;
            Property versionProperty;
            if (!event.isDocumentPart() || (versionProperty = (documentPart = event.getDocumentPart()).getProperty("version")) == null || Objects.equals(versionProperty.getValue(), "1.2")) continue;
            throw new XLIFFFileException.MustBeValid("version must be 1.2");
        }
    }

    private void _validateWellFormedTextUnit(Locale targetLocale, ITextUnit iTextUnit) throws XLIFFFileException.MustBeWellFormed {
        TextContainer textContainer = iTextUnit.getSource();
        Set targetLocaleIds = iTextUnit.getTargetLocales();
        if (!textContainer.isEmpty() && targetLocaleIds.isEmpty()) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
        if (targetLocaleIds.size() > 1) {
            throw new XLIFFFileException.MustBeWellFormed("Only one translation language per file is permitted");
        }
        for (LocaleId targetLocaleId : targetLocaleIds) {
            if (targetLocale != null && !Objects.equals(targetLocale, LocaleUtil.fromLanguageId((String)targetLocaleId.toString()))) {
                throw new XLIFFFileException.MustBeWellFormed("Only one translation language per file is permitted");
            }
            TextContainer targetTextContainer = iTextUnit.getTarget(targetLocaleId);
            if (textContainer.isEmpty() || !targetTextContainer.isEmpty()) continue;
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
    }

    private void _validateXLIFFCompletion(long groupId, XLIFFDocument xliffDocument) throws XLIFFFileException {
        StartXliffData startXliffData = xliffDocument.getStartXliffData();
        String sourceLanguage = startXliffData.getSourceLanguage();
        if (Validator.isNull((String)sourceLanguage)) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation source");
        }
        Locale sourceLocale = LocaleUtil.fromLanguageId((String)sourceLanguage, (boolean)true, (boolean)false);
        if (sourceLocale == null) {
            throw new XLIFFFileException.MustBeSupportedLanguage(sourceLanguage);
        }
        Set availableLocales = this._language.getAvailableLocales(groupId);
        if (!availableLocales.contains(sourceLocale)) {
            throw new XLIFFFileException.MustBeSupportedLanguage(sourceLanguage);
        }
        String targetLanguage = startXliffData.getTargetLanguage();
        if (Validator.isNull((String)targetLanguage)) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
        Locale targetLocale = LocaleUtil.fromLanguageId((String)targetLanguage, (boolean)true, (boolean)false);
        if (targetLocale == null || !availableLocales.contains(targetLocale)) {
            throw new XLIFFFileException.MustBeSupportedLanguage(targetLanguage);
        }
    }

    private void _validateXLIFFDocumentName(InfoItemReference infoItemReference, String xliffDocumentName) throws XLIFFFileException {
        if (infoItemReference == null) {
            return;
        }
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return;
        }
        Matcher matcher = _pattern.matcher(xliffDocumentName);
        if (!matcher.matches()) {
            throw new XLIFFFileException.MustHaveValidId("File ID is invalid");
        }
        String className = matcher.group(1);
        long classPK = GetterUtil.getLong((String)matcher.group(2));
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
        if (Objects.equals(className, infoItemReference.getClassName()) && Objects.equals(classPK, classPKInfoItemIdentifier.getClassPK())) {
            return;
        }
        if (!Objects.equals(className, SegmentsExperience.class.getName())) {
            throw new XLIFFFileException.MustHaveValidId("File ID is invalid");
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(classPK);
        if (segmentsExperience == null || !Objects.equals(segmentsExperience.getPlid(), this._getSegmentsExperienceClassPK(infoItemReference))) {
            throw new XLIFFFileException.MustHaveValidId("File ID is invalid");
        }
    }

    private void _validateXLIFFFile(long groupId, InfoItemReference infoItemReference, XLIFFDocument xliffDocument) throws XLIFFFileException {
        this._validateXLIFFCompletion(groupId, xliffDocument);
        this._validateXLIFFFileNode(infoItemReference, xliffDocument);
    }

    private void _validateXLIFFFileNode(InfoItemReference infoItemReference, XLIFFDocument xliffDocument) throws XLIFFFileException {
        List fileNodeIds = xliffDocument.getFileNodeIds();
        if (fileNodeIds.size() != 1) {
            throw new XLIFFFileException.MustNotHaveMoreThanOne("Only one node is allowed");
        }
        this._validateXLIFFDocumentName(infoItemReference, (String)fileNodeIds.get(0));
    }

    private void _validateXLIFFStartSubdocument(InfoItemReference infoItemReference, StartSubDocument startSubDocument) throws XLIFFFileException {
        if (startSubDocument == null) {
            throw new XLIFFFileException.MustBeWellFormed("The XLIFF file is not well Formed");
        }
        this._validateXLIFFDocumentName(infoItemReference, startSubDocument.getName());
        Property targetLanguageProperty = startSubDocument.getProperty("targetLanguage");
        if (targetLanguageProperty == null || targetLanguageProperty.getValue() == null) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
    }
}

