/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.service.impl;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.info.exception.NoSuchInfoItemException;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.item.updater.InfoItemFieldValuesUpdater;
import com.liferay.petra.io.StreamUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.translation.exception.XLIFFFileException;
import com.liferay.translation.exporter.TranslationInfoItemFieldValuesExporter;
import com.liferay.translation.importer.TranslationInfoItemFieldValuesImporter;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.model.TranslationEntryTable;
import com.liferay.translation.service.base.TranslationEntryLocalServiceBaseImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.translation.model.TranslationEntry"}, service={AopService.class})
public class TranslationEntryLocalServiceImpl
extends TranslationEntryLocalServiceBaseImpl {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference(target="(content.type=application/xliff+xml)")
    private TranslationInfoItemFieldValuesExporter _xliffTranslationInfoItemFieldValuesExporter;
    @Reference(target="(content.type=application/xliff+xml)")
    private TranslationInfoItemFieldValuesImporter _xliffTranslationInfoItemFieldValuesImporter;

    @Indexable(type=IndexableType.REINDEX)
    public TranslationEntry addOrUpdateTranslationEntry(long groupId, String className, long classPK, String content, String contentType, String languageId, ServiceContext serviceContext) throws PortalException {
        this._validateInfoItemGroup(groupId, className, classPK);
        TranslationEntry translationEntry = this.translationEntryPersistence.fetchByC_C_L(this._portal.getClassNameId(className), classPK, languageId);
        if (translationEntry == null) {
            translationEntry = this.translationEntryPersistence.create(this.counterLocalService.increment());
            translationEntry.setUuid(serviceContext.getUuid());
            translationEntry.setGroupId(groupId);
            translationEntry.setCompanyId(serviceContext.getCompanyId());
            translationEntry.setUserId(serviceContext.getUserId());
            translationEntry.setClassName(className);
            translationEntry.setClassPK(classPK);
            translationEntry.setLanguageId(languageId);
            translationEntry.setStatus(2);
        }
        translationEntry.setContent(content);
        translationEntry.setContentType(contentType);
        if (!translationEntry.isDraft() && !translationEntry.isPending()) {
            translationEntry.setStatus(2);
        }
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        translationEntry.setStatusByUserId(user.getUserId());
        translationEntry.setStatusByUserName(user.getFullName());
        translationEntry.setStatusDate(serviceContext.getModifiedDate(new Date()));
        translationEntry = (TranslationEntry)this.translationEntryPersistence.update((BaseModel)translationEntry);
        this._assetEntryLocalService.updateEntry(translationEntry.getUserId(), translationEntry.getGroupId(), translationEntry.getCreateDate(), translationEntry.getModifiedDate(), TranslationEntry.class.getName(), translationEntry.getTranslationEntryId(), translationEntry.getUuid(), 0L, null, null, false, false, null, null, null, null, null, "", "", "", null, null, 0, 0, Double.valueOf(0.0));
        return (TranslationEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)translationEntry.getCompanyId(), (long)translationEntry.getGroupId(), (long)serviceContext.getUserId(), (String)TranslationEntry.class.getName(), (long)translationEntry.getTranslationEntryId(), (Object)translationEntry, (ServiceContext)serviceContext, new HashMap());
    }

    @Indexable(type=IndexableType.REINDEX)
    public TranslationEntry addOrUpdateTranslationEntry(long groupId, String sourceLanguageId, String targetLanguageId, InfoItemReference infoItemReference, InfoItemFieldValues infoItemFieldValues, ServiceContext serviceContext) throws PortalException {
        try {
            infoItemReference = infoItemFieldValues.getInfoItemReference();
            InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
            if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
                throw new NoSuchInfoItemException("Unable to add or update a translation entry without a class PK info item identifier");
            }
            ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
            return this.addOrUpdateTranslationEntry(groupId, infoItemReference.getClassName(), classPKInfoItemIdentifier.getClassPK(), StreamUtil.toString((InputStream)this._xliffTranslationInfoItemFieldValuesExporter.exportInfoItemFieldValues(infoItemFieldValues, LocaleUtil.fromLanguageId((String)sourceLanguageId), LocaleUtil.fromLanguageId((String)targetLanguageId))), this._xliffTranslationInfoItemFieldValuesExporter.getMimeType(), targetLanguageId, serviceContext);
        }
        catch (IOException ioException) {
            throw new PortalException((Throwable)ioException);
        }
    }

    public void deleteTranslationEntries(long classNameId, long classPK) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.translationEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)classNameId));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classPK", (Object)classPK));
        });
        actionableDynamicQuery.setPerformActionMethod(translationEntry -> {
            this.translationEntryLocalService.deleteTranslationEntry(translationEntry);
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(translationEntry.getCompanyId(), translationEntry.getGroupId(), TranslationEntry.class.getName(), translationEntry.getTranslationEntryId());
        });
        actionableDynamicQuery.performActions();
    }

    public void deleteTranslationEntries(String className, long classPK) throws PortalException {
        this.translationEntryLocalService.deleteTranslationEntries(this._portal.getClassNameId(className), classPK);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public TranslationEntry deleteTranslationEntry(long translationEntryId) throws PortalException {
        TranslationEntry translationEntry = this.translationEntryPersistence.remove(translationEntryId);
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(translationEntry.getCompanyId(), translationEntry.getGroupId(), TranslationEntry.class.getName(), translationEntry.getTranslationEntryId());
        return translationEntry;
    }

    public TranslationEntry fetchTranslationEntry(String className, long classPK, String languageId) {
        return this.translationEntryPersistence.fetchByC_C_L(this._portal.getClassNameId(className), classPK, languageId);
    }

    public InfoItemFieldValues getInfoItemFieldValues(long groupId, String className, long classPK, String content) throws PortalException {
        try {
            return this._xliffTranslationInfoItemFieldValuesImporter.importInfoItemFieldValues(groupId, new InfoItemReference(className, classPK), (InputStream)new ByteArrayInputStream(content.getBytes()));
        }
        catch (IOException ioException) {
            throw new PortalException((Throwable)ioException);
        }
    }

    public int getTranslationEntriesCount(String className, long classPK, int[] statuses, boolean exclude) {
        return this.translationEntryPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)TranslationEntryTable.INSTANCE).where(TranslationEntryTable.INSTANCE.classNameId.eq((Object)this._portal.getClassNameId(className)).and((Expression)TranslationEntryTable.INSTANCE.classPK.eq((Object)classPK)).and(() -> {
            if (exclude) {
                return TranslationEntryTable.INSTANCE.status.notIn((Object[])ArrayUtil.toArray((int[])statuses));
            }
            return TranslationEntryTable.INSTANCE.status.in((Object[])ArrayUtil.toArray((int[])statuses));
        })));
    }

    @Indexable(type=IndexableType.REINDEX)
    public TranslationEntry updateStatus(long userId, long translationEntryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        TranslationEntry translationEntry = this.translationEntryPersistence.findByPrimaryKey(translationEntryId);
        if (status == 0) {
            this._updateInfoItem(translationEntry);
        }
        translationEntry.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        translationEntry.setStatusByUserId(user.getUserId());
        translationEntry.setStatusByUserName(user.getFullName());
        translationEntry.setStatusDate(serviceContext.getModifiedDate(new Date()));
        return (TranslationEntry)this.translationEntryPersistence.update((BaseModel)translationEntry);
    }

    private void _updateInfoItem(TranslationEntry translationEntry) throws PortalException {
        try {
            InfoItemFieldValuesUpdater infoItemFieldValuesUpdater = (InfoItemFieldValuesUpdater)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesUpdater.class, translationEntry.getClassName());
            InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, translationEntry.getClassName(), ClassPKInfoItemIdentifier.INFO_ITEM_SERVICE_FILTER);
            String content = translationEntry.getContent();
            infoItemFieldValuesUpdater.updateFromInfoItemFieldValues(infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(translationEntry.getClassPK())), this._xliffTranslationInfoItemFieldValuesImporter.importInfoItemFieldValues(translationEntry.getGroupId(), new InfoItemReference(translationEntry.getClassName(), translationEntry.getClassPK()), (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))));
        }
        catch (PortalException | RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private void _validateInfoItemGroup(long groupId, String className, long classPK) throws XLIFFFileException {
        try {
            GroupedModel groupedModel;
            InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className);
            Object object = infoItemObjectProvider.getInfoItem((InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
            if (object == null) {
                throw new XLIFFFileException.MustHaveValidModel("Unable to get info item for class PK " + classPK);
            }
            if (object instanceof GroupedModel && (groupedModel = (GroupedModel)object).getGroupId() != groupId) {
                throw new XLIFFFileException.MustHaveValidModel(StringBundler.concat((Object[])new Object[]{"Can not import translation for a model in group ", groupedModel.getGroupId(), " into group ", groupId}));
            }
        }
        catch (NoSuchInfoItemException noSuchInfoItemException) {
            throw new XLIFFFileException.MustHaveValidModel((Throwable)noSuchInfoItemException);
        }
    }
}

