/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.service.persistence.impl;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.translation.exception.NoSuchEntryException;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.model.TranslationEntryTable;
import com.liferay.translation.model.impl.TranslationEntryImpl;
import com.liferay.translation.model.impl.TranslationEntryModelImpl;
import com.liferay.translation.service.persistence.TranslationEntryPersistence;
import com.liferay.translation.service.persistence.TranslationEntryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={TranslationEntryPersistence.class})
public class TranslationEntryPersistenceImpl
extends BasePersistenceImpl<TranslationEntry>
implements TranslationEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TranslationEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "translationEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(translationEntry.uuid IS NULL OR translationEntry.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "translationEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(translationEntry.uuid IS NULL OR translationEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "translationEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "translationEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(translationEntry.uuid IS NULL OR translationEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "translationEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByC_C;
    private FinderPath _finderPathWithoutPaginationFindByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "translationEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "translationEntry.classPK = ?";
    private FinderPath _finderPathFetchByC_C_L;
    private static final String _FINDER_COLUMN_C_C_L_CLASSNAMEID_2 = "translationEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_L_CLASSPK_2 = "translationEntry.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_L_LANGUAGEID_2 = "translationEntry.languageId = ?";
    private static final String _FINDER_COLUMN_C_C_L_LANGUAGEID_3 = "(translationEntry.languageId IS NULL OR translationEntry.languageId = '')";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_TRANSLATIONENTRY = "SELECT translationEntry FROM TranslationEntry translationEntry";
    private static final String _SQL_SELECT_TRANSLATIONENTRY_WHERE = "SELECT translationEntry FROM TranslationEntry translationEntry WHERE ";
    private static final String _SQL_COUNT_TRANSLATIONENTRY = "SELECT COUNT(translationEntry) FROM TranslationEntry translationEntry";
    private static final String _SQL_COUNT_TRANSLATIONENTRY_WHERE = "SELECT COUNT(translationEntry) FROM TranslationEntry translationEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "translationEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No TranslationEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No TranslationEntry exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;

    public List<TranslationEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<TranslationEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<TranslationEntry> findByUuid(String uuid, int start, int end, OrderByComparator<TranslationEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<TranslationEntry> findByUuid(String uuid, int start, int end, OrderByComparator<TranslationEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByUuid;
                    finderArgs = new Object[]{uuid};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByUuid;
                finderArgs = new Object[]{uuid, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (TranslationEntry translationEntry : list) {
                    if (uuid.equals(translationEntry.getUuid())) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
                sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append(_FINDER_COLUMN_UUID_UUID_3);
                } else {
                    bindUuid = true;
                    sb.append(_FINDER_COLUMN_UUID_UUID_2);
                }
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY translationEntry.translationEntryId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public TranslationEntry findByUuid_First(String uuid, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (translationEntry != null) {
            return translationEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TranslationEntry fetchByUuid_First(String uuid, OrderByComparator<TranslationEntry> orderByComparator) {
        List<TranslationEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TranslationEntry findByUuid_Last(String uuid, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (translationEntry != null) {
            return translationEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TranslationEntry fetchByUuid_Last(String uuid, OrderByComparator<TranslationEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<TranslationEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TranslationEntry[] findByUuid_PrevAndNext(long translationEntryId, String uuid, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        uuid = Objects.toString(uuid, "");
        TranslationEntry translationEntry = this.findByPrimaryKey(translationEntryId);
        Session session = null;
        try {
            session = this.openSession();
            TranslationEntry[] array = new TranslationEntryImpl[]{this.getByUuid_PrevAndNext(session, translationEntry, uuid, orderByComparator, true), translationEntry, this.getByUuid_PrevAndNext(session, translationEntry, uuid, orderByComparator, false)};
            TranslationEntry[] translationEntryArray = array;
            return translationEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TranslationEntry getByUuid_PrevAndNext(Session session, TranslationEntry translationEntry, String uuid, OrderByComparator<TranslationEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY translationEntry.translationEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)translationEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TranslationEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (TranslationEntry translationEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)translationEntry);
        }
    }

    public int countByUuid(String uuid) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = this._finderPathCountByUuid;
            Object[] finderArgs = new Object[]{uuid};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(2);
                sb.append(_SQL_COUNT_TRANSLATIONENTRY_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append(_FINDER_COLUMN_UUID_UUID_3);
                } else {
                    bindUuid = true;
                    sb.append(_FINDER_COLUMN_UUID_UUID_2);
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public TranslationEntry findByUUID_G(String uuid, long groupId) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByUUID_G(uuid, groupId);
        if (translationEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return translationEntry;
    }

    public TranslationEntry fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public TranslationEntry fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            TranslationEntry translationEntry;
            TranslationEntry translationEntry2;
            uuid = Objects.toString(uuid, "");
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{uuid, groupId};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistence)this);
            }
            if (result instanceof TranslationEntry && (!Objects.equals(uuid, (translationEntry2 = (TranslationEntry)result).getUuid()) || groupId != translationEntry2.getGroupId())) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(4);
                sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append("(translationEntry.uuid IS NULL OR translationEntry.uuid = '') AND ");
                } else {
                    bindUuid = true;
                    sb.append("translationEntry.uuid = ? AND ");
                }
                sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    queryPos.add(groupId);
                    List list = query.list();
                    if (list.isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                        }
                    } else {
                        TranslationEntry translationEntry3 = (TranslationEntry)list.get(0);
                        result = translationEntry3;
                        this.cacheResult(translationEntry3);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                translationEntry = null;
                return translationEntry;
            }
            translationEntry = (TranslationEntry)result;
            return translationEntry;
        }
    }

    public TranslationEntry removeByUUID_G(String uuid, long groupId) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.findByUUID_G(uuid, groupId);
        return (TranslationEntry)this.remove((BaseModel)translationEntry);
    }

    public int countByUUID_G(String uuid, long groupId) {
        TranslationEntry translationEntry = this.fetchByUUID_G(uuid, groupId);
        if (translationEntry == null) {
            return 0;
        }
        return 1;
    }

    public List<TranslationEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<TranslationEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<TranslationEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<TranslationEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<TranslationEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<TranslationEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                    finderArgs = new Object[]{uuid, companyId};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (TranslationEntry translationEntry : list) {
                    if (uuid.equals(translationEntry.getUuid()) && companyId == translationEntry.getCompanyId()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
                sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append("(translationEntry.uuid IS NULL OR translationEntry.uuid = '') AND ");
                } else {
                    bindUuid = true;
                    sb.append("translationEntry.uuid = ? AND ");
                }
                sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY translationEntry.translationEntryId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    queryPos.add(companyId);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public TranslationEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (translationEntry != null) {
            return translationEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TranslationEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<TranslationEntry> orderByComparator) {
        List<TranslationEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TranslationEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (translationEntry != null) {
            return translationEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TranslationEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<TranslationEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<TranslationEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TranslationEntry[] findByUuid_C_PrevAndNext(long translationEntryId, String uuid, long companyId, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        uuid = Objects.toString(uuid, "");
        TranslationEntry translationEntry = this.findByPrimaryKey(translationEntryId);
        Session session = null;
        try {
            session = this.openSession();
            TranslationEntry[] array = new TranslationEntryImpl[]{this.getByUuid_C_PrevAndNext(session, translationEntry, uuid, companyId, orderByComparator, true), translationEntry, this.getByUuid_C_PrevAndNext(session, translationEntry, uuid, companyId, orderByComparator, false)};
            TranslationEntry[] translationEntryArray = array;
            return translationEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TranslationEntry getByUuid_C_PrevAndNext(Session session, TranslationEntry translationEntry, String uuid, long companyId, OrderByComparator<TranslationEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(translationEntry.uuid IS NULL OR translationEntry.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("translationEntry.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY translationEntry.translationEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)translationEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TranslationEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (TranslationEntry translationEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)translationEntry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            uuid = Objects.toString(uuid, "");
            FinderPath finderPath = this._finderPathCountByUuid_C;
            Object[] finderArgs = new Object[]{uuid, companyId};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(3);
                sb.append(_SQL_COUNT_TRANSLATIONENTRY_WHERE);
                boolean bindUuid = false;
                if (uuid.isEmpty()) {
                    sb.append("(translationEntry.uuid IS NULL OR translationEntry.uuid = '') AND ");
                } else {
                    bindUuid = true;
                    sb.append("translationEntry.uuid = ? AND ");
                }
                sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    if (bindUuid) {
                        queryPos.add(uuid);
                    }
                    queryPos.add(companyId);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public List<TranslationEntry> findByC_C(long classNameId, long classPK) {
        return this.findByC_C(classNameId, classPK, -1, -1, null);
    }

    public List<TranslationEntry> findByC_C(long classNameId, long classPK, int start, int end) {
        return this.findByC_C(classNameId, classPK, start, end, null);
    }

    public List<TranslationEntry> findByC_C(long classNameId, long classPK, int start, int end, OrderByComparator<TranslationEntry> orderByComparator) {
        return this.findByC_C(classNameId, classPK, start, end, orderByComparator, true);
    }

    public List<TranslationEntry> findByC_C(long classNameId, long classPK, int start, int end, OrderByComparator<TranslationEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByC_C;
                    finderArgs = new Object[]{classNameId, classPK};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByC_C;
                finderArgs = new Object[]{classNameId, classPK, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (TranslationEntry translationEntry : list) {
                    if (classNameId == translationEntry.getClassNameId() && classPK == translationEntry.getClassPK()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
                sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
                sb.append("translationEntry.classNameId = ? AND ");
                sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY translationEntry.translationEntryId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(classNameId);
                    queryPos.add(classPK);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public TranslationEntry findByC_C_First(long classNameId, long classPK, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByC_C_First(classNameId, classPK, orderByComparator);
        if (translationEntry != null) {
            return translationEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TranslationEntry fetchByC_C_First(long classNameId, long classPK, OrderByComparator<TranslationEntry> orderByComparator) {
        List<TranslationEntry> list = this.findByC_C(classNameId, classPK, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TranslationEntry findByC_C_Last(long classNameId, long classPK, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByC_C_Last(classNameId, classPK, orderByComparator);
        if (translationEntry != null) {
            return translationEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TranslationEntry fetchByC_C_Last(long classNameId, long classPK, OrderByComparator<TranslationEntry> orderByComparator) {
        int count = this.countByC_C(classNameId, classPK);
        if (count == 0) {
            return null;
        }
        List<TranslationEntry> list = this.findByC_C(classNameId, classPK, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TranslationEntry[] findByC_C_PrevAndNext(long translationEntryId, long classNameId, long classPK, OrderByComparator<TranslationEntry> orderByComparator) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.findByPrimaryKey(translationEntryId);
        Session session = null;
        try {
            session = this.openSession();
            TranslationEntry[] array = new TranslationEntryImpl[]{this.getByC_C_PrevAndNext(session, translationEntry, classNameId, classPK, orderByComparator, true), translationEntry, this.getByC_C_PrevAndNext(session, translationEntry, classNameId, classPK, orderByComparator, false)};
            TranslationEntry[] translationEntryArray = array;
            return translationEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TranslationEntry getByC_C_PrevAndNext(Session session, TranslationEntry translationEntry, long classNameId, long classPK, OrderByComparator<TranslationEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
        sb.append("translationEntry.classNameId = ? AND ");
        sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY translationEntry.translationEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(classNameId);
        queryPos.add(classPK);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)translationEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TranslationEntry)list.get(1);
        }
        return null;
    }

    public void removeByC_C(long classNameId, long classPK) {
        for (TranslationEntry translationEntry : this.findByC_C(classNameId, classPK, -1, -1, null)) {
            this.remove((BaseModel)translationEntry);
        }
    }

    public int countByC_C(long classNameId, long classPK) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            FinderPath finderPath = this._finderPathCountByC_C;
            Object[] finderArgs = new Object[]{classNameId, classPK};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(3);
                sb.append(_SQL_COUNT_TRANSLATIONENTRY_WHERE);
                sb.append("translationEntry.classNameId = ? AND ");
                sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(classNameId);
                    queryPos.add(classPK);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public TranslationEntry findByC_C_L(long classNameId, long classPK, String languageId) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByC_C_L(classNameId, classPK, languageId);
        if (translationEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append(", languageId=");
            sb.append(languageId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return translationEntry;
    }

    public TranslationEntry fetchByC_C_L(long classNameId, long classPK, String languageId) {
        return this.fetchByC_C_L(classNameId, classPK, languageId, true);
    }

    public TranslationEntry fetchByC_C_L(long classNameId, long classPK, String languageId, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            TranslationEntry translationEntry;
            TranslationEntry translationEntry2;
            languageId = Objects.toString(languageId, "");
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{classNameId, classPK, languageId};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByC_C_L, finderArgs, (BasePersistence)this);
            }
            if (result instanceof TranslationEntry && (classNameId != (translationEntry2 = (TranslationEntry)result).getClassNameId() || classPK != translationEntry2.getClassPK() || !Objects.equals(languageId, translationEntry2.getLanguageId()))) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(5);
                sb.append(_SQL_SELECT_TRANSLATIONENTRY_WHERE);
                sb.append("translationEntry.classNameId = ? AND ");
                sb.append(_FINDER_COLUMN_C_C_L_CLASSPK_2);
                boolean bindLanguageId = false;
                if (languageId.isEmpty()) {
                    sb.append(_FINDER_COLUMN_C_C_L_LANGUAGEID_3);
                } else {
                    bindLanguageId = true;
                    sb.append(_FINDER_COLUMN_C_C_L_LANGUAGEID_2);
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    List list;
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(classNameId);
                    queryPos.add(classPK);
                    if (bindLanguageId) {
                        queryPos.add(languageId);
                    }
                    if ((list = query.list()).isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByC_C_L, finderArgs, (Object)list);
                        }
                    } else {
                        TranslationEntry translationEntry3 = (TranslationEntry)list.get(0);
                        result = translationEntry3;
                        this.cacheResult(translationEntry3);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                translationEntry = null;
                return translationEntry;
            }
            translationEntry = (TranslationEntry)result;
            return translationEntry;
        }
    }

    public TranslationEntry removeByC_C_L(long classNameId, long classPK, String languageId) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.findByC_C_L(classNameId, classPK, languageId);
        return (TranslationEntry)this.remove((BaseModel)translationEntry);
    }

    public int countByC_C_L(long classNameId, long classPK, String languageId) {
        TranslationEntry translationEntry = this.fetchByC_C_L(classNameId, classPK, languageId);
        if (translationEntry == null) {
            return 0;
        }
        return 1;
    }

    public TranslationEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(TranslationEntry.class);
        this.setModelImplClass(TranslationEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)TranslationEntryTable.INSTANCE);
    }

    public void cacheResult(TranslationEntry translationEntry) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)translationEntry.getCtCollectionId());){
            this.entityCache.putResult(TranslationEntryImpl.class, (Serializable)Long.valueOf(translationEntry.getPrimaryKey()), (Serializable)translationEntry);
            this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{translationEntry.getUuid(), translationEntry.getGroupId()}, (Object)translationEntry);
            this.finderCache.putResult(this._finderPathFetchByC_C_L, new Object[]{translationEntry.getClassNameId(), translationEntry.getClassPK(), translationEntry.getLanguageId()}, (Object)translationEntry);
        }
    }

    public void cacheResult(List<TranslationEntry> translationEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && translationEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (TranslationEntry translationEntry : translationEntries) {
            SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)translationEntry.getCtCollectionId());
            try {
                if (this.entityCache.getResult(TranslationEntryImpl.class, (Serializable)Long.valueOf(translationEntry.getPrimaryKey())) != null) continue;
                this.cacheResult(translationEntry);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(TranslationEntryImpl.class);
        this.finderCache.clearCache(TranslationEntryImpl.class);
    }

    public void clearCache(TranslationEntry translationEntry) {
        this.entityCache.removeResult(TranslationEntryImpl.class, (BaseModel)translationEntry);
    }

    public void clearCache(List<TranslationEntry> translationEntries) {
        for (TranslationEntry translationEntry : translationEntries) {
            this.entityCache.removeResult(TranslationEntryImpl.class, (BaseModel)translationEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(TranslationEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(TranslationEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(TranslationEntryModelImpl translationEntryModelImpl) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)translationEntryModelImpl.getCtCollectionId());){
            Object[] args = new Object[]{translationEntryModelImpl.getUuid(), translationEntryModelImpl.getGroupId()};
            this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)translationEntryModelImpl);
            args = new Object[]{translationEntryModelImpl.getClassNameId(), translationEntryModelImpl.getClassPK(), translationEntryModelImpl.getLanguageId()};
            this.finderCache.putResult(this._finderPathFetchByC_C_L, args, (Object)translationEntryModelImpl);
        }
    }

    public TranslationEntry create(long translationEntryId) {
        TranslationEntryImpl translationEntry = new TranslationEntryImpl();
        translationEntry.setNew(true);
        translationEntry.setPrimaryKey(translationEntryId);
        String uuid = PortalUUIDUtil.generate();
        translationEntry.setUuid(uuid);
        translationEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return translationEntry;
    }

    public TranslationEntry remove(long translationEntryId) throws NoSuchEntryException {
        return this.remove(Long.valueOf(translationEntryId));
    }

    public TranslationEntry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            TranslationEntry translationEntry = (TranslationEntry)session.get(TranslationEntryImpl.class, primaryKey);
            if (translationEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            TranslationEntry translationEntry2 = (TranslationEntry)this.remove((BaseModel)translationEntry);
            return translationEntry2;
        }
        catch (NoSuchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TranslationEntry removeImpl(TranslationEntry translationEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)translationEntry)) {
                translationEntry = (TranslationEntry)session.get(TranslationEntryImpl.class, translationEntry.getPrimaryKeyObj());
            }
            if (translationEntry != null && this.ctPersistenceHelper.isRemove((CTModel)translationEntry)) {
                session.delete((Object)translationEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (translationEntry != null) {
            this.clearCache(translationEntry);
        }
        return translationEntry;
    }

    public TranslationEntry updateImpl(TranslationEntry translationEntry) {
        boolean isNew = translationEntry.isNew();
        if (!(translationEntry instanceof TranslationEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(translationEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)translationEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in translationEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom TranslationEntry implementation " + translationEntry.getClass());
        }
        TranslationEntryModelImpl translationEntryModelImpl = (TranslationEntryModelImpl)translationEntry;
        if (Validator.isNull((String)translationEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            translationEntry.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && translationEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                translationEntry.setCreateDate(date);
            } else {
                translationEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!translationEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                translationEntry.setModifiedDate(date);
            } else {
                translationEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)translationEntry)) {
                if (!isNew) {
                    session.evict(TranslationEntryImpl.class, translationEntry.getPrimaryKeyObj());
                }
                session.save((Object)translationEntry);
            } else {
                translationEntry = (TranslationEntry)session.merge((Object)translationEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(TranslationEntryImpl.class, (BaseModel)translationEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(translationEntryModelImpl);
        if (isNew) {
            translationEntry.setNew(false);
        }
        translationEntry.resetOriginalValues();
        return translationEntry;
    }

    public TranslationEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        TranslationEntry translationEntry = this.fetchByPrimaryKey(primaryKey);
        if (translationEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return translationEntry;
    }

    public TranslationEntry findByPrimaryKey(long translationEntryId) throws NoSuchEntryException {
        return this.findByPrimaryKey(Long.valueOf(translationEntryId));
    }

    public TranslationEntry fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(TranslationEntry.class, primaryKey)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                TranslationEntry translationEntry = (TranslationEntry)super.fetchByPrimaryKey(primaryKey);
                return translationEntry;
            }
        }
        TranslationEntry translationEntry = (TranslationEntry)this.entityCache.getResult(TranslationEntryImpl.class, primaryKey);
        if (translationEntry != null) {
            return translationEntry;
        }
        Session session = null;
        try {
            session = this.openSession();
            translationEntry = (TranslationEntry)session.get(TranslationEntryImpl.class, primaryKey);
            if (translationEntry != null) {
                this.cacheResult(translationEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return translationEntry;
    }

    public TranslationEntry fetchByPrimaryKey(long translationEntryId) {
        return this.fetchByPrimaryKey(Long.valueOf(translationEntryId));
    }

    public Map<Serializable, TranslationEntry> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(TranslationEntry.class)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                Map map = super.fetchByPrimaryKeys(primaryKeys);
                return map;
            }
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, TranslationEntry> map = new HashMap<Serializable, TranslationEntry>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            TranslationEntry translationEntry = this.fetchByPrimaryKey(primaryKey);
            if (translationEntry != null) {
                map.put(primaryKey, translationEntry);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class, primaryKey);
            try {
                TranslationEntry translationEntry = (TranslationEntry)this.entityCache.getResult(TranslationEntryImpl.class, primaryKey);
                if (translationEntry == null) {
                    if (uncachedPrimaryKeys == null) {
                        uncachedPrimaryKeys = new HashSet<Serializable>();
                    }
                    uncachedPrimaryKeys.add(primaryKey);
                    continue;
                }
                map.put(primaryKey, translationEntry);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (TranslationEntry translationEntry : query.list()) {
                map.put(translationEntry.getPrimaryKeyObj(), translationEntry);
                this.cacheResult(translationEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<TranslationEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<TranslationEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<TranslationEntry> findAll(int start, int end, OrderByComparator<TranslationEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<TranslationEntry> findAll(int start, int end, OrderByComparator<TranslationEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindAll;
                    finderArgs = FINDER_ARGS_EMPTY;
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindAll;
                finderArgs = new Object[]{start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache) {
                list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            }
            if (list == null) {
                StringBundler sb = null;
                String sql = null;
                if (orderByComparator != null) {
                    sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                    sb.append(_SQL_SELECT_TRANSLATIONENTRY);
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                    sql = sb.toString();
                } else {
                    sql = _SQL_SELECT_TRANSLATIONENTRY;
                    sql = sql.concat(" ORDER BY translationEntry.translationEntryId ASC");
                }
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public void removeAll() {
        for (TranslationEntry translationEntry : this.findAll()) {
            this.remove((BaseModel)translationEntry);
        }
    }

    public int countAll() {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(TranslationEntry.class);){
            Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
            if (count == null) {
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(_SQL_COUNT_TRANSLATIONENTRY);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "translationEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_TRANSLATIONENTRY;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return TranslationEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "TranslationEntry";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathWithoutPaginationFindByC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathCountByC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, false);
        this._finderPathFetchByC_C_L = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_C_L", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, new String[]{"classNameId", "classPK", "languageId"}, true);
        TranslationEntryUtil.setPersistence((TranslationEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        TranslationEntryUtil.setPersistence(null);
        this.entityCache.removeCache(TranslationEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.translation.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.translation.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.translation.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctIgnoreColumnNames = new HashSet<String>();
        HashSet<String> ctMergeColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("uuid_");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("userId");
        ctStrictColumnNames.add("userName");
        ctStrictColumnNames.add("createDate");
        ctIgnoreColumnNames.add("modifiedDate");
        ctStrictColumnNames.add("classNameId");
        ctStrictColumnNames.add("classPK");
        ctMergeColumnNames.add("content");
        ctMergeColumnNames.add("contentType");
        ctMergeColumnNames.add("languageId");
        ctMergeColumnNames.add("status");
        ctMergeColumnNames.add("statusByUserId");
        ctMergeColumnNames.add("statusByUserName");
        ctMergeColumnNames.add("statusDate");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.IGNORE, ctIgnoreColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.MERGE, ctMergeColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("translationEntryId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"uuid_", "groupId"});
        _uniqueIndexColumnNames.add(new String[]{"classNameId", "classPK", "languageId"});
        _log = LogFactoryUtil.getLog(TranslationEntryPersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    }
}

