/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.exporter;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.translation.exporter.TranslationInfoItemFieldValuesExporter;
import com.liferay.translation.info.field.TranslationInfoFieldChecker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.type=application/x-xliff+xml"}, service={TranslationInfoItemFieldValuesExporter.class})
public class XLIFF12InfoFormTranslationExporter
implements TranslationInfoItemFieldValuesExporter {
    @Reference
    private TranslationInfoFieldChecker _translationInfoFieldChecker;

    public InputStream exportInfoItemFieldValues(InfoItemFieldValues infoItemFieldValues, Locale sourceLocale, Locale targetLocale) throws IOException {
        Document document = SAXReaderUtil.createDocument();
        Element xliffElement = document.addElement("xliff", "urn:oasis:names:tc:xliff:document:1.2");
        xliffElement.addAttribute("version", "1.2");
        Element fileElement = xliffElement.addElement("file");
        fileElement.addAttribute("datatype", "plaintext");
        InfoItemReference infoItemReference = infoItemFieldValues.getInfoItemReference();
        fileElement.addAttribute("original", infoItemReference.getClassName() + ":" + infoItemReference.getClassPK());
        fileElement.addAttribute("source-language", LocaleUtil.toBCP47LanguageId((Locale)sourceLocale));
        fileElement.addAttribute("target-language", LocaleUtil.toBCP47LanguageId((Locale)targetLocale));
        fileElement.addAttribute("tool", "Liferay");
        Element bodyElement = fileElement.addElement("body");
        Collection infoFieldValues = infoItemFieldValues.getInfoFieldValues();
        for (InfoFieldValue infoFieldValue : infoFieldValues) {
            InfoField infoField = infoFieldValue.getInfoField();
            if (!this._translationInfoFieldChecker.isTranslatable(infoField)) continue;
            Element transUnitElement = bodyElement.addElement("trans-unit");
            transUnitElement.addAttribute("id", infoField.getName());
            Element sourceElement = transUnitElement.addElement("source");
            sourceElement.addAttribute("xml:lang", fileElement.attributeValue("source-language"));
            sourceElement.addCDATA(this._getStringValue(infoFieldValue.getValue(sourceLocale)));
            Element targetElement = transUnitElement.addElement("target");
            targetElement.addAttribute("xml:lang", fileElement.attributeValue("target-language"));
            targetElement.addCDATA(this._getStringValue(infoFieldValue.getValue(targetLocale)));
        }
        String formattedString = document.formattedString();
        return new ByteArrayInputStream(formattedString.getBytes());
    }

    public String getMimeType() {
        return "application/x-xliff+xml";
    }

    private String _getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

