/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.exporter;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.translation.exporter.TranslationInfoItemFieldValuesExporter;
import com.liferay.translation.info.field.TranslationInfoFieldChecker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.type=application/xliff+xml"}, service={TranslationInfoItemFieldValuesExporter.class})
public class XLIFF20InfoFormTranslationExporter
implements TranslationInfoItemFieldValuesExporter {
    @Reference
    private TranslationInfoFieldChecker _translationInfoFieldChecker;

    public InputStream exportInfoItemFieldValues(InfoItemFieldValues infoItemFieldValues, Locale sourceLocale, Locale targetLocale) throws IOException {
        Document document = SAXReaderUtil.createDocument();
        Element xliffElement = document.addElement("xliff", "urn:oasis:names:tc:xliff:document:2.0");
        xliffElement.addAttribute("srcLang", LocaleUtil.toBCP47LanguageId((Locale)sourceLocale));
        xliffElement.addAttribute("trgLang", LocaleUtil.toBCP47LanguageId((Locale)targetLocale));
        xliffElement.addAttribute("version", "2.0");
        Element fileElement = xliffElement.addElement("file");
        InfoItemReference infoItemReference = infoItemFieldValues.getInfoItemReference();
        fileElement.addAttribute("id", infoItemReference.getClassName() + ":" + infoItemReference.getClassPK());
        Collection infoFieldValues = infoItemFieldValues.getInfoFieldValues();
        for (InfoFieldValue infoFieldValue : infoFieldValues) {
            InfoField infoField = infoFieldValue.getInfoField();
            if (!this._translationInfoFieldChecker.isTranslatable(infoField)) continue;
            Element unitElement = fileElement.addElement("unit");
            unitElement.addAttribute("id", infoField.getName());
            Element segmentElement = unitElement.addElement("segment");
            Element sourceElement = segmentElement.addElement("source");
            sourceElement.addCDATA(this._getStringValue(infoFieldValue.getValue(sourceLocale)));
            Element targetElement = segmentElement.addElement("target");
            targetElement.addCDATA(this._getStringValue(infoFieldValue.getValue(targetLocale)));
        }
        String formattedString = document.formattedString();
        return new ByteArrayInputStream(formattedString.getBytes());
    }

    public String getMimeType() {
        return "application/xliff+xml";
    }

    private String _getStringValue(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

