/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.importer;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.translation.exception.XLIFFFileException;
import com.liferay.translation.importer.TranslationInfoItemFieldValuesImporter;
import com.liferay.translation.snapshot.TranslationSnapshot;
import com.liferay.translation.snapshot.TranslationSnapshotProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"content.type=application/xliff+xml"}, service={TranslationInfoItemFieldValuesImporter.class, TranslationSnapshotProvider.class})
public class XLIFFInfoFormTranslationImporter
implements TranslationInfoItemFieldValuesImporter,
TranslationSnapshotProvider {
    @Reference
    private Language _language;
    @Reference
    private SAXReader _saxReader;

    public TranslationSnapshot getTranslationSnapshot(long groupId, InfoItemReference infoItemReference, InputStream inputStream) throws IOException, PortalException {
        return this._getTranslationSnapshot(groupId, infoItemReference, inputStream, true);
    }

    public InfoItemFieldValues importInfoItemFieldValues(long groupId, InfoItemReference infoItemReference, InputStream inputStream) throws IOException, XLIFFFileException {
        TranslationSnapshot translationSnapshot = this._getTranslationSnapshot(groupId, infoItemReference, inputStream, false);
        return translationSnapshot.getInfoItemFieldValues();
    }

    private InfoField _createInfoField(Locale locale, String value) {
        return InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).name(value).labelInfoLocalizedValue(InfoLocalizedValue.builder().value(locale, (Object)value).build()).localizable(true).build();
    }

    private InfoItemFieldValues _getInfoItemFieldValuesXLIFFv12(List<Event> events, InfoItemReference infoItemReference, boolean includeSource) throws XLIFFFileException {
        this._validateDocumentPartVersion(events);
        StartSubDocument startSubDocument = this._getStartSubdocument(events);
        this._validateXLIFFStartSubdocument(infoItemReference, startSubDocument);
        Locale sourceLocale = this._getSourceLocale(startSubDocument);
        Locale targetLocale = this._getTargetLocale(startSubDocument);
        return InfoItemFieldValues.builder().infoFieldValue(consumer -> this._produceInfoFieldValuesXLIFFv12((UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException>)consumer, events, sourceLocale, targetLocale, includeSource)).infoItemReference(infoItemReference).build();
    }

    private InfoItemFieldValues _getInfoItemFieldValuesXLIFFv20(long groupId, InfoItemReference infoItemReference, File tempFile, boolean includeSource) throws XLIFFFileException {
        XLIFFDocument xliffDocument = new XLIFFDocument();
        xliffDocument.load(tempFile);
        this._validateXLIFFFile(groupId, infoItemReference, xliffDocument);
        StartXliffData startXliffData = xliffDocument.getStartXliffData();
        Locale sourceLocale = LocaleUtil.fromLanguageId((String)startXliffData.getSourceLanguage(), (boolean)true, (boolean)false);
        Locale targetLocale = LocaleUtil.fromLanguageId((String)startXliffData.getTargetLanguage(), (boolean)true, (boolean)false);
        return InfoItemFieldValues.builder().infoFieldValue(consumer -> this._produceInfoFieldValuesXLIFFv20((UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException>)consumer, xliffDocument, sourceLocale, targetLocale, includeSource)).infoItemReference(infoItemReference).build();
    }

    private Locale _getSourceLocale(StartSubDocument startSubDocument) {
        Property sourceLanguageProperty = startSubDocument.getProperty("sourceLanguage");
        if (sourceLanguageProperty == null || sourceLanguageProperty.getValue() == null) {
            return null;
        }
        return LocaleUtil.fromLanguageId((String)sourceLanguageProperty.getValue());
    }

    private StartSubDocument _getStartSubdocument(List<Event> events) {
        for (Event event : events) {
            if (!event.isStartSubDocument()) continue;
            return event.getStartSubDocument();
        }
        return null;
    }

    private Locale _getTargetLocale(StartSubDocument startSubDocument) {
        Property targetLanguageProperty = startSubDocument.getProperty("targetLanguage");
        if (targetLanguageProperty == null || targetLanguageProperty.getValue() == null) {
            return null;
        }
        return LocaleUtil.fromLanguageId((String)targetLanguageProperty.getValue());
    }

    /*
     * Exception decompiling
     */
    private TranslationSnapshot _getTranslationSnapshot(long groupId, InfoItemReference infoItemReference, InputStream inputStream, boolean includeSource) throws IOException, XLIFFFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean _isVersion20(List<Event> events) {
        for (Event event : events) {
            double version;
            StartDocument startDocument;
            Property versionProperty;
            if (!event.isStartDocument() || (versionProperty = (startDocument = event.getStartDocument()).getProperty("version")) == null || !((version = GetterUtil.getDouble((String)versionProperty.getValue())) >= 2.0) || !(version < 3.0)) continue;
            return true;
        }
        return false;
    }

    private void _produceInfoFieldValuesXLIFFv12(UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException> consumer, List<Event> events, Locale sourceLocale, Locale targetLocale, boolean includeSource) throws XLIFFFileException {
        for (Event event : events) {
            if (!event.isTextUnit()) continue;
            ITextUnit iTextUnit = event.getTextUnit();
            this._validateWellFormedTextUnit(targetLocale, iTextUnit);
            TextContainer sourceTextContainer = iTextUnit.getSource();
            for (LocaleId targetLocaleId : iTextUnit.getTargetLocales()) {
                TextContainer targetTextContainer = iTextUnit.getTarget(targetLocaleId);
                TextFragment targetTextFragment = targetTextContainer.getFirstContent();
                consumer.accept((Object)new InfoFieldValue(this._createInfoField(targetLocale, iTextUnit.getId()), (Object)InfoLocalizedValue.builder().value(targetLocale, (Object)targetTextFragment.getText()).value(biConsumer -> {
                    if (includeSource) {
                        TextFragment sourceTextFragment = sourceTextContainer.getFirstContent();
                        biConsumer.accept((Object)sourceLocale, (Object)sourceTextFragment.getText());
                    }
                }).build()));
            }
        }
    }

    private void _produceInfoFieldValuesXLIFFv20(UnsafeConsumer<InfoFieldValue<Object>, XLIFFFileException> consumer, XLIFFDocument xliffDocument, Locale sourceLocale, Locale targetLocale, boolean includeSource) throws XLIFFFileException {
        for (Unit unit : xliffDocument.getUnits()) {
            if (unit.getPartCount() != 1) {
                throw new XLIFFFileException.MustNotHaveMoreThanOne("The file only can have one unit");
            }
            Part part = unit.getPart(0);
            Fragment targetFragment = part.getTarget();
            if (targetFragment == null) {
                throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
            }
            consumer.accept((Object)new InfoFieldValue(this._createInfoField(targetLocale, unit.getId()), (Object)InfoLocalizedValue.builder().value(targetLocale, (Object)targetFragment.getPlainText()).value(biConsumer -> {
                if (includeSource) {
                    Fragment sourceFragment = part.getSource();
                    biConsumer.accept((Object)sourceLocale, (Object)sourceFragment.getPlainText());
                }
            }).build()));
        }
    }

    private void _validateDocumentPartVersion(List<Event> events) throws XLIFFFileException.MustBeValid {
        for (Event event : events) {
            DocumentPart documentPart;
            Property versionProperty;
            if (!event.isDocumentPart() || (versionProperty = (documentPart = event.getDocumentPart()).getProperty("version")) == null || Objects.equals("1.2", versionProperty.getValue())) continue;
            throw new XLIFFFileException.MustBeValid("version must be 1.2");
        }
    }

    private void _validateWellFormedTextUnit(Locale targetLocale, ITextUnit iTextUnit) throws XLIFFFileException.MustBeWellFormed {
        TextContainer textContainer = iTextUnit.getSource();
        Set targetLocaleIds = iTextUnit.getTargetLocales();
        if (!textContainer.isEmpty() && targetLocaleIds.isEmpty()) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
        if (targetLocaleIds.size() > 1) {
            throw new XLIFFFileException.MustBeWellFormed("Only one translation language per file is permitted");
        }
        for (LocaleId targetLocaleId : targetLocaleIds) {
            if (targetLocale != null && !Objects.equals(targetLocale, LocaleUtil.fromLanguageId((String)targetLocaleId.toString()))) {
                throw new XLIFFFileException.MustBeWellFormed("Only one translation language per file is permitted");
            }
            TextContainer targetTextContainer = iTextUnit.getTarget(targetLocaleId);
            if (textContainer.isEmpty() || !targetTextContainer.isEmpty()) continue;
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
    }

    private void _validateXLIFFCompletion(long groupId, XLIFFDocument xliffDocument) throws XLIFFFileException {
        StartXliffData startXliffData = xliffDocument.getStartXliffData();
        String sourceLanguage = startXliffData.getSourceLanguage();
        if (Validator.isNull((String)sourceLanguage)) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation source");
        }
        Locale sourceLocale = LocaleUtil.fromLanguageId((String)sourceLanguage, (boolean)true, (boolean)false);
        if (sourceLocale == null) {
            throw new XLIFFFileException.MustBeSupportedLanguage(sourceLanguage);
        }
        Set availableLocales = this._language.getAvailableLocales(groupId);
        if (!availableLocales.contains(sourceLocale)) {
            throw new XLIFFFileException.MustBeSupportedLanguage(sourceLanguage);
        }
        String targetLanguage = startXliffData.getTargetLanguage();
        if (Validator.isNull((String)targetLanguage)) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
        Locale targetLocale = LocaleUtil.fromLanguageId((String)targetLanguage, (boolean)true, (boolean)false);
        if (targetLocale == null || !availableLocales.contains(targetLocale)) {
            throw new XLIFFFileException.MustBeSupportedLanguage(targetLanguage);
        }
    }

    private void _validateXLIFFFile(long groupId, InfoItemReference infoItemReference, XLIFFDocument xliffDocument) throws XLIFFFileException {
        this._validateXLIFFCompletion(groupId, xliffDocument);
        this._validateXLIFFFileNode(infoItemReference, xliffDocument);
    }

    private void _validateXLIFFFileNode(InfoItemReference infoItemReference, XLIFFDocument xliffDocument) throws XLIFFFileException {
        List fileNodeIds = xliffDocument.getFileNodeIds();
        if (fileNodeIds.size() != 1) {
            throw new XLIFFFileException.MustNotHaveMoreThanOne("Only one node is allowed");
        }
        FileNode fileNode = xliffDocument.getFileNode(infoItemReference.getClassName() + ":" + infoItemReference.getClassPK());
        if (fileNode == null) {
            throw new XLIFFFileException.MustHaveValidId("File ID is invalid");
        }
    }

    private void _validateXLIFFStartSubdocument(InfoItemReference infoItemReference, StartSubDocument startSubDocument) throws XLIFFFileException {
        if (startSubDocument == null) {
            throw new XLIFFFileException.MustBeWellFormed("The XLIFF file is not well Formed");
        }
        String original = infoItemReference.getClassName() + ":" + infoItemReference.getClassPK();
        if (!Objects.equals(startSubDocument.getName(), original)) {
            throw new XLIFFFileException.MustHaveValidId("File ID is invalid");
        }
        Property targetLanguageProperty = startSubDocument.getProperty("targetLanguage");
        if (targetLanguageProperty == null || targetLanguageProperty.getValue() == null) {
            throw new XLIFFFileException.MustBeWellFormed("There is no translation target");
        }
    }
}

