/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.info.item.updater;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.storage.constants.FieldConstants;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.updater.InfoItemFieldValuesUpdater;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"item.class.name=com.liferay.journal.model.JournalArticle"}, service={InfoItemFieldValuesUpdater.class})
public class JournalArticleInfoItemFieldValuesUpdaterImpl
implements InfoItemFieldValuesUpdater<JournalArticle> {
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalConverter _journalConverter;

    public JournalArticle updateFromInfoItemFieldValues(JournalArticle journalArticle, InfoItemFieldValues infoItemFieldValues) throws Exception {
        HashMap importedLocaleTitleMap = new HashMap();
        HashMap importedLocaleDescriptionMap = new HashMap();
        HashMap<Locale, Map<String, String>> importedLocaleContentMap = new HashMap<Locale, Map<String, String>>();
        HashSet translatedLocales = new HashSet();
        HashMap fieldNameContentMap = new HashMap();
        for (InfoFieldValue infoFieldValue : infoItemFieldValues.getInfoFieldValues()) {
            this._getInfoLocalizedValueOptional((InfoFieldValue<Object>)infoFieldValue).ifPresent(infoLocalizedValue -> {
                InfoField infoField = infoFieldValue.getInfoField();
                for (Locale locale : infoLocalizedValue.getAvailableLocales()) {
                    if (infoFieldValue.getValue(locale) == null || !(infoFieldValue.getValue(locale) instanceof String)) continue;
                    translatedLocales.add(locale);
                    String fieldName = infoField.getName();
                    String valueString = String.valueOf(infoFieldValue.getValue(locale));
                    if (Objects.equals("description", fieldName)) {
                        importedLocaleDescriptionMap.put(locale, valueString);
                        continue;
                    }
                    if (Objects.equals("title", fieldName)) {
                        importedLocaleTitleMap.put(locale, valueString);
                        continue;
                    }
                    fieldNameContentMap.put(fieldName, valueString);
                    importedLocaleContentMap.put(locale, fieldNameContentMap);
                }
            });
        }
        JournalArticle latestArticle = this._journalArticleLocalService.getLatestArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), -1);
        Map titleMap = latestArticle.getTitleMap();
        Map descriptionMap = latestArticle.getDescriptionMap();
        String translatedContent = latestArticle.getContent();
        for (Locale targetLocale : translatedLocales) {
            titleMap.put(targetLocale, this._getTranslatedString(latestArticle.getTitle(targetLocale), latestArticle.getTitle(), (String)importedLocaleTitleMap.get(targetLocale)));
            descriptionMap.put(targetLocale, this._getTranslatedString(latestArticle.getDescription(targetLocale), latestArticle.getDescription(), (String)importedLocaleDescriptionMap.get(targetLocale)));
            translatedContent = this._getTranslatedContent(translatedContent, latestArticle.getDDMStructure(), importedLocaleContentMap, targetLocale);
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setFormDate(new Date());
        serviceContext.setScopeGroupId(latestArticle.getGroupId());
        if (latestArticle.getStatus() != 0) {
            serviceContext.setWorkflowAction(2);
        } else {
            serviceContext.setWorkflowAction(1);
        }
        return this._journalArticleLocalService.updateArticle(latestArticle.getUserId(), latestArticle.getGroupId(), latestArticle.getFolderId(), latestArticle.getArticleId(), latestArticle.getVersion(), titleMap, descriptionMap, translatedContent, latestArticle.getLayoutUuid(), serviceContext);
    }

    private void _addNewTranslatedDDMField(DDMStructure ddmStructure, Locale targetLocale, String ddmFieldName, Fields ddmFields, String ddmFieldValue) throws Exception {
        Field ddmField = new Field(ddmStructure.getStructureId(), ddmFieldName, Collections.emptyList(), ddmFields.getDefaultLocale());
        ddmField.setValue(targetLocale, FieldConstants.getSerializable((Locale)targetLocale, (Locale)targetLocale, (String)ddmStructure.getFieldType(ddmFieldName), (String)ddmFieldValue));
        ddmFields.put(ddmField);
        this._updateFieldsDisplay(ddmFields, ddmFieldName);
    }

    private Optional<InfoLocalizedValue<Object>> _getInfoLocalizedValueOptional(InfoFieldValue<Object> infoFieldValue) {
        Object value = infoFieldValue.getValue();
        if (value instanceof InfoLocalizedValue) {
            return Optional.of((InfoLocalizedValue)value);
        }
        return Optional.empty();
    }

    private String _getTranslatedContent(String content, DDMStructure ddmStructure, Map<Locale, Map<String, String>> importedLocaleContentMap, Locale targetLocale) throws Exception {
        Map<String, String> contentFieldMap = importedLocaleContentMap.get(targetLocale);
        if (contentFieldMap == null || contentFieldMap.isEmpty()) {
            return content;
        }
        Fields ddmFields = this._journalConverter.getDDMFields(ddmStructure, content);
        for (Map.Entry<String, String> entry : contentFieldMap.entrySet()) {
            Field field = ddmFields.get(entry.getKey());
            if (field != null) {
                field.setValue(targetLocale, FieldConstants.getSerializable((Locale)targetLocale, (Locale)targetLocale, (String)field.getDataType(), (String)entry.getValue()));
                continue;
            }
            if (!ddmStructure.hasField(entry.getKey())) continue;
            this._addNewTranslatedDDMField(ddmStructure, targetLocale, entry.getKey(), ddmFields, entry.getValue());
        }
        return this._journalConverter.getContent(ddmStructure, ddmFields, ddmStructure.getGroupId());
    }

    private String _getTranslatedString(String currentString, String defaultString, String importedString) {
        if (importedString != null) {
            return importedString;
        }
        if (Validator.isNotNull((String)currentString)) {
            return currentString;
        }
        return defaultString;
    }

    private void _updateFieldsDisplay(Fields ddmFields, String fieldName) {
        String fieldsDisplayValue = StringBundler.concat((String[])new String[]{fieldName, "_INSTANCE_", StringUtil.randomString()});
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldsDisplayValue);
        fieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }
}

