/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.security.permission.resource;

import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemPermissionProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.service.TranslationEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.translation.model.TranslationEntry"}, service={ModelResourcePermission.class})
public class TranslationEntryModelResourcePermission
implements ModelResourcePermission<TranslationEntry> {
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private TranslationEntryLocalService _translationEntryLocalService;

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, primaryKey, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, TranslationEntry.class.getName(), primaryKey, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, TranslationEntry translationEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, translationEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, TranslationEntry.class.getName(), translationEntry.getTranslationEntryId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._translationEntryLocalService.getTranslationEntry(primaryKey), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, TranslationEntry translationEntry, String actionId) throws PortalException {
        InfoItemPermissionProvider infoItemPermissionProvider = (InfoItemPermissionProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemPermissionProvider.class, translationEntry.getClassName());
        if (infoItemPermissionProvider.hasPermission(permissionChecker, new InfoItemReference(translationEntry.getClassName(), translationEntry.getClassPK()), actionId)) {
            return true;
        }
        String name = "com.liferay.translation." + translationEntry.getLanguageId();
        return permissionChecker.hasPermission(translationEntry.getGroupId(), name, name, "TRANSLATE");
    }

    public String getModelName() {
        return TranslationEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }
}

