/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceWrapper;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.service.TranslationEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class TranslationEntryResourcePermissionLocalServiceWrapper
extends ResourcePermissionLocalServiceWrapper {
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private TranslationEntryLocalService _translationEntryLocalService;

    public TranslationEntryResourcePermissionLocalServiceWrapper() {
        super(null);
    }

    public TranslationEntryResourcePermissionLocalServiceWrapper(ResourcePermissionLocalService resourcePermissionLocalService) {
        super(resourcePermissionLocalService);
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException {
        if (!StringUtil.startsWith((String)name, (String)TranslationEntry.class.getName())) {
            return super.hasResourcePermission(companyId, name, scope, primKey, roleId, actionId);
        }
        if (scope != 4) {
            return false;
        }
        TranslationEntry translationEntry = this._translationEntryLocalService.fetchTranslationEntry(GetterUtil.getLong((String)primKey));
        if (translationEntry == null) {
            return super.hasResourcePermission(companyId, name, scope, primKey, roleId, actionId);
        }
        if (this._resourcePermissionLocalService.hasResourcePermission(companyId, translationEntry.getClassName(), scope, String.valueOf(translationEntry.getClassPK()), roleId, "UPDATE")) {
            return true;
        }
        String languageResourceName = "com.liferay.translation." + translationEntry.getLanguageId();
        return this._resourcePermissionLocalService.hasResourcePermission(companyId, languageResourceName, scope, languageResourceName, roleId, "TRANSLATE");
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long[] roleIds, String actionId) throws PortalException {
        if (!StringUtil.startsWith((String)name, (String)TranslationEntry.class.getName())) {
            return super.hasResourcePermission(companyId, name, scope, primKey, roleIds, actionId);
        }
        if (scope != 4) {
            return false;
        }
        TranslationEntry translationEntry = this._translationEntryLocalService.fetchTranslationEntry(GetterUtil.getLong((String)primKey));
        if (translationEntry == null) {
            return super.hasResourcePermission(companyId, name, scope, primKey, roleIds, actionId);
        }
        if (this._resourcePermissionLocalService.hasResourcePermission(companyId, translationEntry.getClassName(), scope, String.valueOf(translationEntry.getClassPK()), roleIds, "UPDATE")) {
            return true;
        }
        String languageResourceName = "com.liferay.translation." + translationEntry.getLanguageId();
        return this._resourcePermissionLocalService.hasResourcePermission(companyId, languageResourceName, scope, languageResourceName, roleIds, "TRANSLATE");
    }
}

