/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.internal.util;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.sf.okapi.common.LocaleId;

public class XLIFFLocaleIdUtil {
    private static final LocaleId _defaultLocaleId = LocaleId.fromString((String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));

    public static LocaleId getSourceLocaleId(Document document) {
        return XLIFFLocaleIdUtil._getLocaleId(document, "srcLang", "source-language");
    }

    public static LocaleId getTargetLocaleId(Document document) {
        return XLIFFLocaleIdUtil._getLocaleId(document, "trgLang", "target-language");
    }

    private static <T> Optional<T> _getAttributeValueOptional(Element element, String attributeName, Function<String, T> function) {
        if (element == null) {
            return Optional.empty();
        }
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return Optional.empty();
        }
        return Optional.of(function.apply(attribute.getValue()));
    }

    private static LocaleId _getLocaleId(Document document, String attributeName, String alternateAttributeName) {
        Element rootElement = document.getRootElement();
        return XLIFFLocaleIdUtil._getAttributeValueOptional(rootElement, attributeName, LocaleId::fromString).orElseGet(() -> XLIFFLocaleIdUtil._getAttributeValueOptional(rootElement.element("file"), alternateAttributeName, LocaleId::fromString).orElse(_defaultLocaleId));
    }
}

