/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.service.TranslationEntryLocalService;
import com.liferay.translation.service.TranslationEntryService;
import com.liferay.translation.service.TranslationEntryServiceUtil;
import com.liferay.translation.service.persistence.TranslationEntryPersistence;
import java.lang.reflect.Field;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class TranslationEntryServiceBaseImpl
extends BaseServiceImpl
implements AopService,
IdentifiableOSGiService,
TranslationEntryService {
    @Reference
    protected TranslationEntryLocalService translationEntryLocalService;
    protected TranslationEntryService translationEntryService;
    @Reference
    protected TranslationEntryPersistence translationEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;

    @Deactivate
    protected void deactivate() {
        this._setServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{TranslationEntryService.class, IdentifiableOSGiService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.translationEntryService = (TranslationEntryService)aopProxy;
        this._setServiceUtilService(this.translationEntryService);
    }

    public String getOSGiServiceIdentifier() {
        return TranslationEntryService.class.getName();
    }

    protected Class<?> getModelClass() {
        return TranslationEntry.class;
    }

    protected String getModelClassName() {
        return TranslationEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.translationEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setServiceUtilService(TranslationEntryService translationEntryService) {
        try {
            Field field = TranslationEntryServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, translationEntryService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

