/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.service.impl;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.info.item.updater.InfoItemFieldValuesUpdater;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.translation.exporter.TranslationInfoItemFieldValuesExporter;
import com.liferay.translation.importer.TranslationInfoItemFieldValuesImporter;
import com.liferay.translation.model.TranslationEntry;
import com.liferay.translation.service.base.TranslationEntryLocalServiceBaseImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.translation.model.TranslationEntry"}, service={AopService.class})
public class TranslationEntryLocalServiceImpl
extends TranslationEntryLocalServiceBaseImpl {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;
    @Reference(target="(content.type=application/xliff+xml)")
    private TranslationInfoItemFieldValuesExporter _xliffTranslationInfoItemFieldValuesExporter;
    @Reference(target="(content.type=application/xliff+xml)")
    private TranslationInfoItemFieldValuesImporter _xliffTranslationInfoItemFieldValuesImporter;

    @Indexable(type=IndexableType.REINDEX)
    public TranslationEntry addOrUpdateTranslationEntry(long groupId, String languageId, InfoItemReference infoItemReference, InfoItemFieldValues infoItemFieldValues, ServiceContext serviceContext) throws PortalException {
        try {
            return this.addOrUpdateTranslationEntry(groupId, infoItemReference.getClassName(), infoItemReference.getClassPK(), StreamUtil.toString((InputStream)this._xliffTranslationInfoItemFieldValuesExporter.exportInfoItemFieldValues(infoItemFieldValues, LocaleUtil.getDefault(), LocaleUtil.fromLanguageId((String)languageId))), this._xliffTranslationInfoItemFieldValuesExporter.getMimeType(), languageId, serviceContext);
        }
        catch (IOException ioException) {
            throw new PortalException((Throwable)ioException);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public TranslationEntry addOrUpdateTranslationEntry(long groupId, String className, long classPK, String content, String contentType, String languageId, ServiceContext serviceContext) throws PortalException {
        TranslationEntry translationEntry = this.translationEntryPersistence.fetchByC_C_L(this._portal.getClassNameId(className), classPK, languageId);
        if (translationEntry == null) {
            translationEntry = this.translationEntryPersistence.create(this.counterLocalService.increment());
            translationEntry.setUuid(serviceContext.getUuid());
            translationEntry.setGroupId(groupId);
            translationEntry.setCompanyId(serviceContext.getCompanyId());
            translationEntry.setUserId(serviceContext.getUserId());
            translationEntry.setClassName(className);
            translationEntry.setClassPK(classPK);
            translationEntry.setLanguageId(languageId);
            translationEntry.setStatus(2);
        }
        translationEntry.setContent(content);
        translationEntry.setContentType(contentType);
        if (!translationEntry.isDraft() && !translationEntry.isPending()) {
            translationEntry.setStatus(2);
        }
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        translationEntry.setStatusByUserId(user.getUserId());
        translationEntry.setStatusByUserName(user.getFullName());
        translationEntry.setStatusDate(serviceContext.getModifiedDate(new Date()));
        translationEntry = (TranslationEntry)this.translationEntryPersistence.update((BaseModel)translationEntry);
        this._assetEntryLocalService.updateEntry(translationEntry.getUserId(), translationEntry.getGroupId(), translationEntry.getCreateDate(), translationEntry.getModifiedDate(), TranslationEntry.class.getName(), translationEntry.getTranslationEntryId(), translationEntry.getUuid(), 0L, null, null, false, false, null, null, null, null, null, "", "", "", null, null, 0, 0, Double.valueOf(0.0));
        return (TranslationEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)translationEntry.getCompanyId(), (long)translationEntry.getGroupId(), (long)serviceContext.getUserId(), (String)TranslationEntry.class.getName(), (long)translationEntry.getTranslationEntryId(), (Object)translationEntry, (ServiceContext)serviceContext, new HashMap());
    }

    public void deleteTranslationEntries(long classNameId, long classPK) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.translationEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)classNameId));
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classPK", (Object)classPK));
        });
        actionableDynamicQuery.setPerformActionMethod(translationEntry -> this.translationEntryLocalService.deleteTranslationEntry(translationEntry));
        actionableDynamicQuery.performActions();
    }

    public void deleteTranslationEntries(String className, long classPK) throws PortalException {
        this.translationEntryLocalService.deleteTranslationEntries(this._portal.getClassNameId(className), classPK);
    }

    public TranslationEntry fetchTranslationEntry(String className, long classPK, String languageId) {
        return this.translationEntryPersistence.fetchByC_C_L(this._portal.getClassNameId(className), classPK, languageId);
    }

    public InfoItemFieldValues getInfoItemFieldValues(long groupId, String className, long classPK, String content) throws PortalException {
        try {
            return this._xliffTranslationInfoItemFieldValuesImporter.importInfoItemFieldValues(groupId, new InfoItemReference(className, classPK), (InputStream)new ByteArrayInputStream(content.getBytes()));
        }
        catch (IOException ioException) {
            throw new PortalException((Throwable)ioException);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public TranslationEntry updateStatus(long userId, long translationEntryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        TranslationEntry translationEntry = this.translationEntryPersistence.findByPrimaryKey(translationEntryId);
        if (status == 0) {
            this._updateInfoItem(translationEntry);
        }
        translationEntry.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        translationEntry.setStatusByUserId(user.getUserId());
        translationEntry.setStatusByUserName(user.getFullName());
        translationEntry.setStatusDate(serviceContext.getModifiedDate(new Date()));
        return (TranslationEntry)this.translationEntryPersistence.update((BaseModel)translationEntry);
    }

    private void _updateInfoItem(TranslationEntry translationEntry) throws PortalException {
        try {
            InfoItemFieldValuesUpdater infoItemFieldValuesUpdater = (InfoItemFieldValuesUpdater)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesUpdater.class, translationEntry.getClassName());
            InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemObjectProvider.class, translationEntry.getClassName());
            String content = translationEntry.getContent();
            infoItemFieldValuesUpdater.updateFromInfoItemFieldValues(infoItemObjectProvider.getInfoItem(translationEntry.getClassPK()), this._xliffTranslationInfoItemFieldValuesImporter.importInfoItemFieldValues(translationEntry.getGroupId(), new InfoItemReference(translationEntry.getClassName(), translationEntry.getClassPK()), (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))));
        }
        catch (PortalException | RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }
}

