/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.translator.aws.internal.translator;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.translation.translator.BaseTranslator;
import com.liferay.translation.translator.Translator;
import com.liferay.translation.translator.TranslatorPacket;
import com.liferay.translation.translator.aws.internal.configuration.AWSTranslatorConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.TranslateClientBuilder;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.model.TranslateTextResponse;

@Component(configurationPid={"com.liferay.translation.translator.aws.internal.configuration.AWSTranslatorConfiguration"}, service={Translator.class})
public class AWSTranslator
extends BaseTranslator {
    @Reference
    private ConfigurationProvider _configurationProvider;

    public boolean isEnabled(long companyId) throws ConfigurationException {
        AWSTranslatorConfiguration awsTranslatorConfiguration = (AWSTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(AWSTranslatorConfiguration.class, companyId);
        return awsTranslatorConfiguration.enabled();
    }

    public TranslatorPacket translate(final TranslatorPacket translatorPacket) throws PortalException {
        AWSTranslatorConfiguration awsTranslatorConfiguration = (AWSTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(AWSTranslatorConfiguration.class, translatorPacket.getCompanyId());
        if (!awsTranslatorConfiguration.enabled()) {
            return translatorPacket;
        }
        TranslateClient translateClient = (TranslateClient)((TranslateClientBuilder)((TranslateClientBuilder)TranslateClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)awsTranslatorConfiguration.accessKey(), (String)awsTranslatorConfiguration.secretKey())))).region(Region.of((String)awsTranslatorConfiguration.region()))).build();
        final HashMap translatedFieldsMap = new HashMap();
        String sourceLanguageCode = this.getLanguageCode(translatorPacket.getSourceLanguageId());
        String targetLanguageCode = this.getLanguageCode(translatorPacket.getTargetLanguageId());
        Map fieldsMap = translatorPacket.getFieldsMap();
        fieldsMap.forEach((key, value) -> translatedFieldsMap.put(key, this._translate(translateClient, (String)value, sourceLanguageCode, targetLanguageCode)));
        return new TranslatorPacket(){

            public long getCompanyId() {
                return translatorPacket.getCompanyId();
            }

            public Map<String, String> getFieldsMap() {
                return translatedFieldsMap;
            }

            public Map<String, Boolean> getHTMLMap() {
                return translatorPacket.getHTMLMap();
            }

            public String getSourceLanguageId() {
                return translatorPacket.getSourceLanguageId();
            }

            public String getTargetLanguageId() {
                return translatorPacket.getTargetLanguageId();
            }
        };
    }

    private String _translate(TranslateClient translateClient, String text, String sourceLanguageCode, String targetLanguageCode) {
        if (Validator.isBlank((String)text)) {
            return text;
        }
        TranslateTextResponse translateTextResponse = translateClient.translateText(builder -> {
            TranslateTextRequest cfr_ignored_0 = (TranslateTextRequest)builder.sourceLanguageCode(sourceLanguageCode).targetLanguageCode(targetLanguageCode).text(text).build();
        });
        return translateTextResponse.translatedText();
    }
}

