/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.translator.azure.internal;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.url.URLBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.translation.translator.BaseTranslator;
import com.liferay.translation.translator.Translator;
import com.liferay.translation.translator.TranslatorPacket;
import com.liferay.translation.translator.azure.internal.configuration.AzureTranslatorConfiguration;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.translation.translator.azure.internal.configuration.AzureTranslatorConfiguration"}, service={Translator.class})
public class AzureTranslator
extends BaseTranslator {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;

    public boolean isEnabled(long companyId) throws ConfigurationException {
        AzureTranslatorConfiguration azureTranslatorConfiguration = (AzureTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(AzureTranslatorConfiguration.class, companyId);
        return azureTranslatorConfiguration.enabled();
    }

    public TranslatorPacket translate(final TranslatorPacket translatorPacket) throws PortalException {
        AzureTranslatorConfiguration azureTranslatorConfiguration = (AzureTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(AzureTranslatorConfiguration.class, translatorPacket.getCompanyId());
        if (!azureTranslatorConfiguration.enabled()) {
            return translatorPacket;
        }
        try {
            Http.Options options = new Http.Options();
            options.addHeader("Ocp-Apim-Subscription-Key", azureTranslatorConfiguration.subscriptionKey());
            options.addHeader("Ocp-Apim-Subscription-Region", azureTranslatorConfiguration.resourceLocation());
            options.addHeader("Content-Type", "application/json");
            options.setBody(this._getTranslatorPacketPayload(translatorPacket), "application/json", "UTF-8");
            options.setLocation(URLBuilder.create((String)"https://api.cognitive.microsofttranslator.com/translate").addParameter("api-version", "3.0").addParameter("from", this.getLanguageCode(translatorPacket.getSourceLanguageId())).addParameter("to", this.getLanguageCode(translatorPacket.getTargetLanguageId())).build());
            options.setPost(true);
            String json = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() != 200) {
                throw new PortalException("Response code " + response.getResponseCode());
            }
            final Map<String, String> translatedFieldsMap = this._getTranslatedFieldsMap(translatorPacket.getFieldsMap(), this._jsonFactory.createJSONArray(json));
            return new TranslatorPacket(){

                public long getCompanyId() {
                    return translatorPacket.getCompanyId();
                }

                public Map<String, String> getFieldsMap() {
                    return translatedFieldsMap;
                }

                public Map<String, Boolean> getHTMLMap() {
                    return translatorPacket.getHTMLMap();
                }

                public String getSourceLanguageId() {
                    return translatorPacket.getSourceLanguageId();
                }

                public String getTargetLanguageId() {
                    return translatorPacket.getTargetLanguageId();
                }
            };
        }
        catch (IOException ioException) {
            throw new PortalException((Throwable)ioException);
        }
    }

    private Map<String, String> _getTranslatedFieldsMap(Map<String, String> fieldsMap, JSONArray jsonArray) {
        HashMap<String, String> translatedFieldsMap = new HashMap<String, String>();
        int i = 0;
        for (String key : fieldsMap.keySet()) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray translationsJSONArray = jsonObject.getJSONArray("translations");
            JSONObject translationJSONObject = translationsJSONArray.getJSONObject(0);
            translatedFieldsMap.put(key, translationJSONObject.getString("text"));
            ++i;
        }
        return translatedFieldsMap;
    }

    private String _getTranslatorPacketPayload(TranslatorPacket translatorPacket) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        Map fields = translatorPacket.getFieldsMap();
        fields.forEach((key, value) -> jsonArray.put(JSONUtil.put((String)"Text", (Object)value)));
        return jsonArray.toString();
    }
}

