/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.translator.deepl.internal.translator;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.translation.exception.TranslatorException;
import com.liferay.translation.translator.BaseTranslator;
import com.liferay.translation.translator.Translator;
import com.liferay.translation.translator.TranslatorPacket;
import com.liferay.translation.translator.deepl.internal.configuration.DeepLTranslatorConfiguration;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.translation.translator.deepl.internal.configuration.DeepLTranslatorConfiguration"}, service={Translator.class})
public class DeepLTranslator
extends BaseTranslator {
    private static final Log _log = LogFactoryUtil.getLog(DeepLTranslator.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;

    public boolean isEnabled(long companyId) throws ConfigurationException {
        DeepLTranslatorConfiguration deepLTranslatorConfiguration = (DeepLTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(DeepLTranslatorConfiguration.class, companyId);
        return deepLTranslatorConfiguration.enabled();
    }

    public TranslatorPacket translate(final TranslatorPacket translatorPacket) throws PortalException {
        String targetLanguageCode;
        DeepLTranslatorConfiguration deepLTranslatorConfiguration = (DeepLTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(DeepLTranslatorConfiguration.class, translatorPacket.getCompanyId());
        if (!deepLTranslatorConfiguration.enabled()) {
            return translatorPacket;
        }
        List<String> supportedLanguageCodes = this._getSupportedLanguageCodes(deepLTranslatorConfiguration);
        if (!supportedLanguageCodes.contains(targetLanguageCode = StringUtil.toUpperCase((String)this.getLanguageCode(translatorPacket.getTargetLanguageId())))) {
            throw new TranslatorException(StringBundler.concat((String[])new String[]{"Target language code ", targetLanguageCode, " is not among the supported language codes: ", StringUtil.merge(supportedLanguageCodes, (String)", ")}));
        }
        final Map<String, String> translatedFieldsMap = this._translate(deepLTranslatorConfiguration, translatorPacket.getFieldsMap(), translatorPacket.getHTMLMap(), StringUtil.toUpperCase((String)this.getLanguageCode(translatorPacket.getSourceLanguageId())), targetLanguageCode);
        return new TranslatorPacket(){

            public long getCompanyId() {
                return translatorPacket.getCompanyId();
            }

            public Map<String, String> getFieldsMap() {
                return translatedFieldsMap;
            }

            public Map<String, Boolean> getHTMLMap() {
                return translatorPacket.getHTMLMap();
            }

            public String getSourceLanguageId() {
                return translatorPacket.getSourceLanguageId();
            }

            public String getTargetLanguageId() {
                return translatorPacket.getTargetLanguageId();
            }
        };
    }

    private List<String> _getSupportedLanguageCodes(DeepLTranslatorConfiguration deepLTranslatorConfiguration) throws PortalException {
        Http.Options options = new Http.Options();
        options.addPart("type", "target");
        options.setMethod(Http.Method.GET);
        return JSONUtil.toList((JSONArray)this._jsonFactory.createJSONArray(this._invoke(deepLTranslatorConfiguration.authKey(), options, deepLTranslatorConfiguration.validateLanguageURL())), jsonObject -> jsonObject.getString("language"), (Log)_log);
    }

    private String _invoke(String authKey, Http.Options options, String url) throws PortalException {
        String json = null;
        options.addHeader("Authorization", "DeepL-Auth-Key " + authKey);
        options.setLocation(url);
        try {
            json = this._http.URLtoString(options);
        }
        catch (IOException ioException) {
            throw new TranslatorException((Throwable)ioException);
        }
        Http.Response response = options.getResponse();
        Response.Status status = Response.Status.fromStatusCode((int)response.getResponseCode());
        if (status == Response.Status.OK) {
            return json;
        }
        throw new TranslatorException("HTTP response status " + status);
    }

    private Map<String, String> _translate(DeepLTranslatorConfiguration deepLTranslatorConfiguration, Map<String, String> fieldsMap, Map<String, Boolean> htmlMap, String sourceLanguageCode, String targetLanguageCode) throws PortalException {
        HashMap<String, String> translatedFieldsMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldsMap.entrySet()) {
            Boolean html = htmlMap.get(entry.getKey());
            translatedFieldsMap.put(entry.getKey(), this._translate(deepLTranslatorConfiguration, sourceLanguageCode, targetLanguageCode, entry.getValue(), html));
        }
        return translatedFieldsMap;
    }

    private String _translate(DeepLTranslatorConfiguration deepLTranslatorConfiguration, String sourceLanguageCode, String targetLanguageCode, String text, Boolean html) throws PortalException {
        if (Validator.isBlank((String)text)) {
            return text;
        }
        JSONObject requestJSONObject = this._jsonFactory.createJSONObject();
        if (html != null && html.booleanValue()) {
            requestJSONObject.put("tag_handling", "html");
        }
        requestJSONObject.put("source_lang", sourceLanguageCode).put("target_lang", targetLanguageCode).put("text", (Object)new String[]{text});
        Http.Body body = new Http.Body(requestJSONObject.toString(), "application/json", "UTF-8");
        Http.Options options = new Http.Options();
        options.addHeader("Content-Type", "application/json");
        options.setBody(body);
        options.setMethod(Http.Method.POST);
        JSONObject jsonObject = this._jsonFactory.createJSONObject(this._invoke(deepLTranslatorConfiguration.authKey(), options, deepLTranslatorConfiguration.url()));
        JSONArray jsonArray = jsonObject.getJSONArray("translations");
        JSONObject translationJSONObject = jsonArray.getJSONObject(0);
        return translationJSONObject.getString("text");
    }
}

