/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.translator.google.cloud.internal.configuration.persistence.listener;

import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.translation.translator.google.cloud.internal.configuration.GoogleCloudTranslatorConfiguration;
import java.util.Dictionary;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.translation.translator.google.cloud.internal.configuration.GoogleCloudTranslatorConfiguration"}, service={ConfigurationModelListener.class})
public class GoogleCloudTranslatorConfigurationModelListener
implements ConfigurationModelListener {
    private static final Log _log = LogFactoryUtil.getLog(GoogleCloudTranslatorConfigurationModelListener.class);
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        boolean enabled = GetterUtil.getBoolean((Object)properties.get("enabled"));
        String serviceAccountPrivateKey = GetterUtil.getString((Object)properties.get("serviceAccountPrivateKey"));
        if (enabled && !this._isValid(serviceAccountPrivateKey)) {
            throw new ConfigurationModelListenerException(this._language.get(LocaleThreadLocal.getThemeDisplayLocale(), "the-service-account-private-key-must-be-in-json-format"), GoogleCloudTranslatorConfiguration.class, this.getClass(), properties);
        }
    }

    private boolean _isValid(String serviceAccountPrivateKey) {
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(serviceAccountPrivateKey);
            return jsonObject.length() > 0;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }
}

