/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.translator.google.cloud.internal.translator;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.translation.exception.TranslatorException;
import com.liferay.translation.translator.BaseTranslator;
import com.liferay.translation.translator.Translator;
import com.liferay.translation.translator.TranslatorPacket;
import com.liferay.translation.translator.google.cloud.internal.configuration.GoogleCloudTranslatorConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.translation.translator.google.cloud.internal.configuration.GoogleCloudTranslatorConfiguration"}, service={Translator.class})
public class GoogleCloudTranslator
extends BaseTranslator {
    @Reference
    private ConfigurationProvider _configurationProvider;

    public boolean isEnabled(long companyId) throws ConfigurationException {
        GoogleCloudTranslatorConfiguration googleCloudTranslatorConfiguration = (GoogleCloudTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(GoogleCloudTranslatorConfiguration.class, companyId);
        return googleCloudTranslatorConfiguration.enabled() && !Validator.isBlank((String)googleCloudTranslatorConfiguration.serviceAccountPrivateKey());
    }

    public TranslatorPacket translate(final TranslatorPacket translatorPacket) throws PortalException {
        GoogleCloudTranslatorConfiguration googleCloudTranslatorConfiguration = (GoogleCloudTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(GoogleCloudTranslatorConfiguration.class, translatorPacket.getCompanyId());
        if (!googleCloudTranslatorConfiguration.enabled()) {
            return translatorPacket;
        }
        String sourceLanguageCode = this.getLanguageCode(translatorPacket.getSourceLanguageId());
        String targetLanguageCode = this.getLanguageCode(translatorPacket.getTargetLanguageId());
        Translate translate = this._getTranslate(googleCloudTranslatorConfiguration);
        Set supportedLanguageCodes = SetUtil.fromCollection((Collection)TransformUtil.transform((Collection)translate.listSupportedLanguages(new Translate.LanguageListOption[0]), Language::getCode));
        if (!supportedLanguageCodes.contains(sourceLanguageCode) || !supportedLanguageCodes.contains(targetLanguageCode)) {
            throw new TranslatorException("Translation between the selected languages is not supported");
        }
        Map fieldsMap = translatorPacket.getFieldsMap();
        List translations = translate.translate(new ArrayList(fieldsMap.values()), new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)sourceLanguageCode), Translate.TranslateOption.targetLanguage((String)targetLanguageCode)});
        final HashMap<String, String> translationFieldsMap = new HashMap<String, String>();
        Iterator iterator = translations.iterator();
        for (String key : fieldsMap.keySet()) {
            Translation translation = (Translation)iterator.next();
            translationFieldsMap.put(key, translation.getTranslatedText());
        }
        return new TranslatorPacket(){

            public long getCompanyId() {
                return translatorPacket.getCompanyId();
            }

            public Map<String, String> getFieldsMap() {
                return translationFieldsMap;
            }

            public Map<String, Boolean> getHTMLMap() {
                return translatorPacket.getHTMLMap();
            }

            public String getSourceLanguageId() {
                return translatorPacket.getSourceLanguageId();
            }

            public String getTargetLanguageId() {
                return translatorPacket.getTargetLanguageId();
            }
        };
    }

    private Translate _getTranslate(GoogleCloudTranslatorConfiguration googleCloudTranslatorConfiguration) throws ConfigurationException {
        String serviceAccountPrivateKey = googleCloudTranslatorConfiguration.serviceAccountPrivateKey();
        ServiceAccountCredentials serviceAccountCredentials = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(serviceAccountPrivateKey.getBytes());){
            serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to authenticate with Google Cloud", (Throwable)ioException);
        }
        TranslateOptions.DefaultTranslateFactory defaultTranslateFactory = new TranslateOptions.DefaultTranslateFactory();
        return defaultTranslateFactory.create(((TranslateOptions.Builder)TranslateOptions.newBuilder().setCredentials((Credentials)serviceAccountCredentials)).build());
    }
}

