/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashEntryList;
import com.liferay.trash.service.TrashEntryServiceUtil;
import java.util.List;

public class TrashEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(TrashEntryServiceHttp.class);
    private static final Class<?>[] _deleteEntriesParameterTypes0 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteEntriesParameterTypes1 = new Class[]{long[].class};
    private static final Class<?>[] _deleteEntryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteEntryParameterTypes3 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes5 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getEntriesParameterTypes6 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getEntriesParameterTypes7 = new Class[]{Long.TYPE, String.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _moveEntryParameterTypes8 = new Class[]{String.class, Long.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _restoreEntryParameterTypes9 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreEntryParameterTypes10 = new Class[]{Long.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _restoreEntryParameterTypes11 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _restoreEntryParameterTypes12 = new Class[]{String.class, Long.TYPE, Long.TYPE, String.class};

    public static void deleteEntries(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntries", (Class[])_deleteEntriesParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteEntries(HttpPrincipal httpPrincipal, long[] entryIds) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntries", (Class[])_deleteEntriesParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryIds});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntry", (Class[])_deleteEntryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntry", (Class[])_deleteEntryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static TrashEntryList getEntries(HttpPrincipal httpPrincipal, long groupId) throws PrincipalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PrincipalException) {
                    throw (PrincipalException)exception;
                }
                throw new SystemException((Throwable)exception);
            }
            return (TrashEntryList)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static TrashEntryList getEntries(HttpPrincipal httpPrincipal, long groupId, int start, int end, OrderByComparator<TrashEntry> orderByComparator) throws PrincipalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PrincipalException) {
                    throw (PrincipalException)exception;
                }
                throw new SystemException((Throwable)exception);
            }
            return (TrashEntryList)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<TrashEntry> getEntries(HttpPrincipal httpPrincipal, long groupId, String className) throws PrincipalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, className});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PrincipalException) {
                    throw (PrincipalException)exception;
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static TrashEntryList getEntries(HttpPrincipal httpPrincipal, long groupId, String className, int start, int end, OrderByComparator<TrashEntry> orderByComparator) throws PrincipalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, className, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PrincipalException) {
                    throw (PrincipalException)exception;
                }
                throw new SystemException((Throwable)exception);
            }
            return (TrashEntryList)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void moveEntry(HttpPrincipal httpPrincipal, String className, long classPK, long destinationContainerModelId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "moveEntry", (Class[])_moveEntryParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, destinationContainerModelId, serviceContext});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static TrashEntry restoreEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "restoreEntry", (Class[])_restoreEntryParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (TrashEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static TrashEntry restoreEntry(HttpPrincipal httpPrincipal, long entryId, long overrideClassPK, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "restoreEntry", (Class[])_restoreEntryParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, overrideClassPK, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (TrashEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static TrashEntry restoreEntry(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "restoreEntry", (Class[])_restoreEntryParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (TrashEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static TrashEntry restoreEntry(HttpPrincipal httpPrincipal, String className, long classPK, long overrideClassPK, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "restoreEntry", (Class[])_restoreEntryParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, overrideClassPK, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (TrashEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

