/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.trash.exception.NoSuchEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashEntryTable;
import com.liferay.trash.model.impl.TrashEntryImpl;
import com.liferay.trash.model.impl.TrashEntryModelImpl;
import com.liferay.trash.service.persistence.TrashEntryPersistence;
import com.liferay.trash.service.persistence.TrashEntryUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={TrashEntryPersistence.class})
public class TrashEntryPersistenceImpl
extends BasePersistenceImpl<TrashEntry>
implements TrashEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = TrashEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "trashEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "trashEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByG_LtCD;
    private FinderPath _finderPathWithPaginationCountByG_LtCD;
    private static final String _FINDER_COLUMN_G_LTCD_GROUPID_2 = "trashEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_LTCD_CREATEDATE_1 = "trashEntry.createDate IS NULL";
    private static final String _FINDER_COLUMN_G_LTCD_CREATEDATE_2 = "trashEntry.createDate < ?";
    private FinderPath _finderPathWithPaginationFindByG_C;
    private FinderPath _finderPathWithoutPaginationFindByG_C;
    private FinderPath _finderPathCountByG_C;
    private static final String _FINDER_COLUMN_G_C_GROUPID_2 = "trashEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_CLASSNAMEID_2 = "trashEntry.classNameId = ?";
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "trashEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "trashEntry.classPK = ?";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private BundleContext _bundleContext;
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_TRASHENTRY = "SELECT trashEntry FROM TrashEntry trashEntry";
    private static final String _SQL_SELECT_TRASHENTRY_WHERE = "SELECT trashEntry FROM TrashEntry trashEntry WHERE ";
    private static final String _SQL_COUNT_TRASHENTRY = "SELECT COUNT(trashEntry) FROM TrashEntry trashEntry";
    private static final String _SQL_COUNT_TRASHENTRY_WHERE = "SELECT COUNT(trashEntry) FROM TrashEntry trashEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "trashEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No TrashEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No TrashEntry exists with the key {";
    private static final Log _log;
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<TrashEntry> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<TrashEntry> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<TrashEntry> findByGroupId(long groupId, int start, int end, OrderByComparator<TrashEntry> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<TrashEntry> findByGroupId(long groupId, int start, int end, OrderByComparator<TrashEntry> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (TrashEntry trashEntry : list) {
                if (groupId == trashEntry.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY trashEntry.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public TrashEntry findByGroupId_First(long groupId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByGroupId_First(groupId, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByGroupId_First(long groupId, OrderByComparator<TrashEntry> orderByComparator) {
        List<TrashEntry> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry findByGroupId_Last(long groupId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByGroupId_Last(long groupId, OrderByComparator<TrashEntry> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<TrashEntry> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry[] findByGroupId_PrevAndNext(long entryId, long groupId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            TrashEntry[] array = new TrashEntryImpl[]{this.getByGroupId_PrevAndNext(session, trashEntry, groupId, orderByComparator, true), trashEntry, this.getByGroupId_PrevAndNext(session, trashEntry, groupId, orderByComparator, false)};
            TrashEntry[] trashEntryArray = array;
            return trashEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashEntry getByGroupId_PrevAndNext(Session session, TrashEntry trashEntry, long groupId, OrderByComparator<TrashEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
        sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashEntry.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashEntry)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (TrashEntry trashEntry : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)trashEntry);
        }
    }

    public int countByGroupId(long groupId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByGroupId;
            finderArgs = new Object[]{groupId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_TRASHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<TrashEntry> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<TrashEntry> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<TrashEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<TrashEntry> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<TrashEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<TrashEntry> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (TrashEntry trashEntry : list) {
                if (companyId == trashEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY trashEntry.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public TrashEntry findByCompanyId_First(long companyId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByCompanyId_First(long companyId, OrderByComparator<TrashEntry> orderByComparator) {
        List<TrashEntry> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry findByCompanyId_Last(long companyId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByCompanyId_Last(long companyId, OrderByComparator<TrashEntry> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<TrashEntry> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry[] findByCompanyId_PrevAndNext(long entryId, long companyId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            TrashEntry[] array = new TrashEntryImpl[]{this.getByCompanyId_PrevAndNext(session, trashEntry, companyId, orderByComparator, true), trashEntry, this.getByCompanyId_PrevAndNext(session, trashEntry, companyId, orderByComparator, false)};
            TrashEntry[] trashEntryArray = array;
            return trashEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashEntry getByCompanyId_PrevAndNext(Session session, TrashEntry trashEntry, long companyId, OrderByComparator<TrashEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashEntry.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashEntry)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (TrashEntry trashEntry : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)trashEntry);
        }
    }

    public int countByCompanyId(long companyId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByCompanyId;
            finderArgs = new Object[]{companyId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_TRASHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<TrashEntry> findByG_LtCD(long groupId, Date createDate) {
        return this.findByG_LtCD(groupId, createDate, -1, -1, null);
    }

    public List<TrashEntry> findByG_LtCD(long groupId, Date createDate, int start, int end) {
        return this.findByG_LtCD(groupId, createDate, start, end, null);
    }

    public List<TrashEntry> findByG_LtCD(long groupId, Date createDate, int start, int end, OrderByComparator<TrashEntry> orderByComparator) {
        return this.findByG_LtCD(groupId, createDate, start, end, orderByComparator, true);
    }

    public List<TrashEntry> findByG_LtCD(long groupId, Date createDate, int start, int end, OrderByComparator<TrashEntry> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByG_LtCD;
        finderArgs = new Object[]{groupId, TrashEntryPersistenceImpl._getTime(createDate), start, end, orderByComparator};
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (TrashEntry trashEntry : list) {
                if (groupId == trashEntry.getGroupId() && createDate.getTime() > trashEntry.getCreateDate().getTime()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
            sb.append("trashEntry.groupId = ? AND ");
            boolean bindCreateDate = false;
            if (createDate == null) {
                sb.append(_FINDER_COLUMN_G_LTCD_CREATEDATE_1);
            } else {
                bindCreateDate = true;
                sb.append(_FINDER_COLUMN_G_LTCD_CREATEDATE_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY trashEntry.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindCreateDate) {
                    queryPos.add(new Timestamp(createDate.getTime()));
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public TrashEntry findByG_LtCD_First(long groupId, Date createDate, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByG_LtCD_First(groupId, createDate, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", createDate<");
        sb.append((Object)createDate);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByG_LtCD_First(long groupId, Date createDate, OrderByComparator<TrashEntry> orderByComparator) {
        List<TrashEntry> list = this.findByG_LtCD(groupId, createDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry findByG_LtCD_Last(long groupId, Date createDate, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByG_LtCD_Last(groupId, createDate, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", createDate<");
        sb.append((Object)createDate);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByG_LtCD_Last(long groupId, Date createDate, OrderByComparator<TrashEntry> orderByComparator) {
        int count = this.countByG_LtCD(groupId, createDate);
        if (count == 0) {
            return null;
        }
        List<TrashEntry> list = this.findByG_LtCD(groupId, createDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry[] findByG_LtCD_PrevAndNext(long entryId, long groupId, Date createDate, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            TrashEntry[] array = new TrashEntryImpl[]{this.getByG_LtCD_PrevAndNext(session, trashEntry, groupId, createDate, orderByComparator, true), trashEntry, this.getByG_LtCD_PrevAndNext(session, trashEntry, groupId, createDate, orderByComparator, false)};
            TrashEntry[] trashEntryArray = array;
            return trashEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashEntry getByG_LtCD_PrevAndNext(Session session, TrashEntry trashEntry, long groupId, Date createDate, OrderByComparator<TrashEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
        sb.append("trashEntry.groupId = ? AND ");
        boolean bindCreateDate = false;
        if (createDate == null) {
            sb.append(_FINDER_COLUMN_G_LTCD_CREATEDATE_1);
        } else {
            bindCreateDate = true;
            sb.append(_FINDER_COLUMN_G_LTCD_CREATEDATE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashEntry.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (bindCreateDate) {
            queryPos.add(new Timestamp(createDate.getTime()));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashEntry)list.get(1);
        }
        return null;
    }

    public void removeByG_LtCD(long groupId, Date createDate) {
        for (TrashEntry trashEntry : this.findByG_LtCD(groupId, createDate, -1, -1, null)) {
            this.remove((BaseModel)trashEntry);
        }
    }

    public int countByG_LtCD(long groupId, Date createDate) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathWithPaginationCountByG_LtCD;
            finderArgs = new Object[]{groupId, TrashEntryPersistenceImpl._getTime(createDate)};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_TRASHENTRY_WHERE);
            sb.append("trashEntry.groupId = ? AND ");
            boolean bindCreateDate = false;
            if (createDate == null) {
                sb.append(_FINDER_COLUMN_G_LTCD_CREATEDATE_1);
            } else {
                bindCreateDate = true;
                sb.append(_FINDER_COLUMN_G_LTCD_CREATEDATE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                if (bindCreateDate) {
                    queryPos.add(new Timestamp(createDate.getTime()));
                }
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<TrashEntry> findByG_C(long groupId, long classNameId) {
        return this.findByG_C(groupId, classNameId, -1, -1, null);
    }

    public List<TrashEntry> findByG_C(long groupId, long classNameId, int start, int end) {
        return this.findByG_C(groupId, classNameId, start, end, null);
    }

    public List<TrashEntry> findByG_C(long groupId, long classNameId, int start, int end, OrderByComparator<TrashEntry> orderByComparator) {
        return this.findByG_C(groupId, classNameId, start, end, orderByComparator, true);
    }

    public List<TrashEntry> findByG_C(long groupId, long classNameId, int start, int end, OrderByComparator<TrashEntry> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByG_C;
                finderArgs = new Object[]{groupId, classNameId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByG_C;
            finderArgs = new Object[]{groupId, classNameId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (TrashEntry trashEntry : list) {
                if (groupId == trashEntry.getGroupId() && classNameId == trashEntry.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
            sb.append("trashEntry.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_CLASSNAMEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY trashEntry.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(classNameId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public TrashEntry findByG_C_First(long groupId, long classNameId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByG_C_First(groupId, classNameId, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByG_C_First(long groupId, long classNameId, OrderByComparator<TrashEntry> orderByComparator) {
        List<TrashEntry> list = this.findByG_C(groupId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry findByG_C_Last(long groupId, long classNameId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByG_C_Last(groupId, classNameId, orderByComparator);
        if (trashEntry != null) {
            return trashEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public TrashEntry fetchByG_C_Last(long groupId, long classNameId, OrderByComparator<TrashEntry> orderByComparator) {
        int count = this.countByG_C(groupId, classNameId);
        if (count == 0) {
            return null;
        }
        List<TrashEntry> list = this.findByG_C(groupId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public TrashEntry[] findByG_C_PrevAndNext(long entryId, long groupId, long classNameId, OrderByComparator<TrashEntry> orderByComparator) throws NoSuchEntryException {
        TrashEntry trashEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            TrashEntry[] array = new TrashEntryImpl[]{this.getByG_C_PrevAndNext(session, trashEntry, groupId, classNameId, orderByComparator, true), trashEntry, this.getByG_C_PrevAndNext(session, trashEntry, groupId, classNameId, orderByComparator, false)};
            TrashEntry[] trashEntryArray = array;
            return trashEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashEntry getByG_C_PrevAndNext(Session session, TrashEntry trashEntry, long groupId, long classNameId, OrderByComparator<TrashEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
        sb.append("trashEntry.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_C_CLASSNAMEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY trashEntry.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)trashEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (TrashEntry)list.get(1);
        }
        return null;
    }

    public void removeByG_C(long groupId, long classNameId) {
        for (TrashEntry trashEntry : this.findByG_C(groupId, classNameId, -1, -1, null)) {
            this.remove((BaseModel)trashEntry);
        }
    }

    public int countByG_C(long groupId, long classNameId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByG_C;
            finderArgs = new Object[]{groupId, classNameId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_TRASHENTRY_WHERE);
            sb.append("trashEntry.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_CLASSNAMEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(classNameId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public TrashEntry findByC_C(long classNameId, long classPK) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByC_C(classNameId, classPK);
        if (trashEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return trashEntry;
    }

    public TrashEntry fetchByC_C(long classNameId, long classPK) {
        return this.fetchByC_C(classNameId, classPK, true);
    }

    public TrashEntry fetchByC_C(long classNameId, long classPK, boolean useFinderCache) {
        TrashEntry trashEntry;
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{classNameId, classPK};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof TrashEntry && (classNameId != (trashEntry = (TrashEntry)result).getClassNameId() || classPK != trashEntry.getClassPK())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_TRASHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByC_C, finderArgs, (Object)list);
                    }
                } else {
                    TrashEntry trashEntry2 = (TrashEntry)list.get(0);
                    result = trashEntry2;
                    this.cacheResult(trashEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (TrashEntry)result;
    }

    public TrashEntry removeByC_C(long classNameId, long classPK) throws NoSuchEntryException {
        TrashEntry trashEntry = this.findByC_C(classNameId, classPK);
        return (TrashEntry)this.remove((BaseModel)trashEntry);
    }

    public int countByC_C(long classNameId, long classPK) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByC_C;
            finderArgs = new Object[]{classNameId, classPK};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_TRASHENTRY_WHERE);
            sb.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            sb.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(classNameId);
                queryPos.add(classPK);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public TrashEntryPersistenceImpl() {
        this.setModelClass(TrashEntry.class);
        this.setModelImplClass(TrashEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)TrashEntryTable.INSTANCE);
    }

    public void cacheResult(TrashEntry trashEntry) {
        if (trashEntry.getCtCollectionId() != 0L) {
            return;
        }
        this.entityCache.putResult(TrashEntryImpl.class, (Serializable)Long.valueOf(trashEntry.getPrimaryKey()), (Serializable)trashEntry);
        this.finderCache.putResult(this._finderPathFetchByC_C, new Object[]{trashEntry.getClassNameId(), trashEntry.getClassPK()}, (Object)trashEntry);
    }

    public void cacheResult(List<TrashEntry> trashEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && trashEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (TrashEntry trashEntry : trashEntries) {
            if (trashEntry.getCtCollectionId() != 0L || this.entityCache.getResult(TrashEntryImpl.class, (Serializable)Long.valueOf(trashEntry.getPrimaryKey())) != null) continue;
            this.cacheResult(trashEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(TrashEntryImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(TrashEntry trashEntry) {
        this.entityCache.removeResult(TrashEntryImpl.class, (BaseModel)trashEntry);
    }

    public void clearCache(List<TrashEntry> trashEntries) {
        for (TrashEntry trashEntry : trashEntries) {
            this.entityCache.removeResult(TrashEntryImpl.class, (BaseModel)trashEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(TrashEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(TrashEntryModelImpl trashEntryModelImpl) {
        Object[] args = new Object[]{trashEntryModelImpl.getClassNameId(), trashEntryModelImpl.getClassPK()};
        this.finderCache.putResult(this._finderPathCountByC_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_C, args, (Object)trashEntryModelImpl, false);
    }

    public TrashEntry create(long entryId) {
        TrashEntryImpl trashEntry = new TrashEntryImpl();
        trashEntry.setNew(true);
        trashEntry.setPrimaryKey(entryId);
        trashEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return trashEntry;
    }

    public TrashEntry remove(long entryId) throws NoSuchEntryException {
        return this.remove(Long.valueOf(entryId));
    }

    public TrashEntry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            TrashEntry trashEntry = (TrashEntry)session.get(TrashEntryImpl.class, primaryKey);
            if (trashEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            TrashEntry trashEntry2 = (TrashEntry)this.remove((BaseModel)trashEntry);
            return trashEntry2;
        }
        catch (NoSuchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected TrashEntry removeImpl(TrashEntry trashEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)trashEntry)) {
                trashEntry = (TrashEntry)session.get(TrashEntryImpl.class, trashEntry.getPrimaryKeyObj());
            }
            if (trashEntry != null && this.ctPersistenceHelper.isRemove((CTModel)trashEntry)) {
                session.delete((Object)trashEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (trashEntry != null) {
            this.clearCache(trashEntry);
        }
        return trashEntry;
    }

    public TrashEntry updateImpl(TrashEntry trashEntry) {
        boolean isNew = trashEntry.isNew();
        if (!(trashEntry instanceof TrashEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(trashEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)trashEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in trashEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom TrashEntry implementation " + trashEntry.getClass());
        }
        TrashEntryModelImpl trashEntryModelImpl = (TrashEntryModelImpl)trashEntry;
        if (isNew && trashEntry.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                trashEntry.setCreateDate(date);
            } else {
                trashEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)trashEntry)) {
                if (!isNew) {
                    session.evict(TrashEntryImpl.class, trashEntry.getPrimaryKeyObj());
                }
                session.save((Object)trashEntry);
            } else {
                trashEntry = (TrashEntry)session.merge((Object)trashEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (trashEntry.getCtCollectionId() != 0L) {
            if (isNew) {
                trashEntry.setNew(false);
            }
            trashEntry.resetOriginalValues();
            return trashEntry;
        }
        this.entityCache.putResult(TrashEntryImpl.class, (BaseModel)trashEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(trashEntryModelImpl);
        if (isNew) {
            trashEntry.setNew(false);
        }
        trashEntry.resetOriginalValues();
        return trashEntry;
    }

    public TrashEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        TrashEntry trashEntry = this.fetchByPrimaryKey(primaryKey);
        if (trashEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return trashEntry;
    }

    public TrashEntry findByPrimaryKey(long entryId) throws NoSuchEntryException {
        return this.findByPrimaryKey(Long.valueOf(entryId));
    }

    public TrashEntry fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(TrashEntry.class)) {
            return (TrashEntry)super.fetchByPrimaryKey(primaryKey);
        }
        TrashEntry trashEntry = null;
        Session session = null;
        try {
            session = this.openSession();
            trashEntry = (TrashEntry)session.get(TrashEntryImpl.class, primaryKey);
            if (trashEntry != null) {
                this.cacheResult(trashEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return trashEntry;
    }

    public TrashEntry fetchByPrimaryKey(long entryId) {
        return this.fetchByPrimaryKey(Long.valueOf(entryId));
    }

    public Map<Serializable, TrashEntry> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(TrashEntry.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, TrashEntry> map = new HashMap<Serializable, TrashEntry>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            TrashEntry trashEntry = this.fetchByPrimaryKey(primaryKey);
            if (trashEntry != null) {
                map.put(primaryKey, trashEntry);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (TrashEntry trashEntry : query.list()) {
                map.put(trashEntry.getPrimaryKeyObj(), trashEntry);
                this.cacheResult(trashEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<TrashEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<TrashEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<TrashEntry> findAll(int start, int end, OrderByComparator<TrashEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<TrashEntry> findAll(int start, int end, OrderByComparator<TrashEntry> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_TRASHENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_TRASHENTRY;
                sql = sql.concat(" ORDER BY trashEntry.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (TrashEntry trashEntry : this.findAll()) {
            this.remove((BaseModel)trashEntry);
        }
    }

    public int countAll() {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(TrashEntry.class);
        Long count = null;
        if (productionMode) {
            count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_TRASHENTRY);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "entryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_TRASHENTRY;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return TrashEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "TrashEntry";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new TrashEntryModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)TrashEntry.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByGroupId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathWithoutPaginationFindByGroupId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._finderPathWithPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByG_LtCD = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_LtCD", new String[]{Long.class.getName(), Date.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "createDate"}, true);
        this._finderPathWithPaginationCountByG_LtCD = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByG_LtCD", new String[]{Long.class.getName(), Date.class.getName()}, new String[]{"groupId", "createDate"}, false);
        this._finderPathWithPaginationFindByG_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "classNameId"}, true);
        this._finderPathWithoutPaginationFindByG_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "classNameId"}, true);
        this._finderPathCountByG_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "classNameId"}, false);
        this._finderPathFetchByC_C = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathCountByC_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, false);
        this._setTrashEntryUtilPersistence(this);
    }

    @Deactivate
    public void deactivate() {
        this._setTrashEntryUtilPersistence(null);
        this.entityCache.removeCache(TrashEntryImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _setTrashEntryUtilPersistence(TrashEntryPersistence trashEntryPersistence) {
        try {
            Field field = TrashEntryUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, trashEntryPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.trash.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.trash.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.trash.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private static Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("userId");
        ctStrictColumnNames.add("userName");
        ctStrictColumnNames.add("createDate");
        ctStrictColumnNames.add("classNameId");
        ctStrictColumnNames.add("classPK");
        ctStrictColumnNames.add("systemEventSetKey");
        ctStrictColumnNames.add("typeSettings");
        ctStrictColumnNames.add("status");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("entryId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"classNameId", "classPK"});
        _log = LogFactoryUtil.getLog(TrashEntryPersistenceImpl.class);
    }

    private static class TrashEntryModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private TrashEntryModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            TrashEntryModelImpl trashEntryModelImpl = (TrashEntryModelImpl)baseModel;
            long columnBitmask = trashEntryModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return TrashEntryModelArgumentsResolver._getValue(trashEntryModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | TrashEntryModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return TrashEntryModelArgumentsResolver._getValue(trashEntryModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(TrashEntryModelImpl trashEntryModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? trashEntryModelImpl.getColumnOriginalValue(columnName) : trashEntryModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= TrashEntryModelImpl.getColumnBitmask("createDate");
        }
    }
}

