/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.internal.search;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.trash.model.TrashEntry;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;

@Component(service={Indexer.class})
public class TrashIndexer
extends BaseIndexer<TrashEntry> {
    public static final String CLASS_NAME = TrashEntry.class.getName();

    public TrashIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "removedByUserName", "removedDate", "rootEntryClassName", "rootEntryClassPK", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public BooleanQuery getFullQuery(SearchContext searchContext) throws SearchException {
        try {
            BooleanFilter fullQueryBooleanFilter = new BooleanFilter();
            fullQueryBooleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
            List trashHandlers = TrashHandlerRegistryUtil.getTrashHandlers();
            for (TrashHandler trashHandler : trashHandlers) {
                Filter filter = trashHandler.getExcludeFilter(searchContext);
                if (filter == null) continue;
                fullQueryBooleanFilter.add(filter, BooleanClauseOccur.MUST_NOT);
            }
            long[] groupIds = searchContext.getGroupIds();
            if (ArrayUtil.isNotEmpty((long[])groupIds)) {
                TermsFilter groupTermsFilter = new TermsFilter("groupId");
                groupTermsFilter.addValues(ArrayUtil.toStringArray((long[])groupIds));
                fullQueryBooleanFilter.add((Filter)groupTermsFilter, BooleanClauseOccur.MUST);
            }
            fullQueryBooleanFilter.addRequiredTerm("status", 8);
            return this.createFullQuery(fullQueryBooleanFilter, searchContext);
        }
        catch (SearchException searchException) {
            throw searchException;
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entryClassName);
        return trashHandler.hasTrashPermission(permissionChecker, 0L, entryClassPK, actionId);
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        if (searchContext.getAttributes() == null) {
            return;
        }
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", true);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", true);
        this.addSearchTerm(searchQuery, searchContext, "removedByUserName", true);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", true);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", true);
    }

    protected void doDelete(TrashEntry trashEntry) {
    }

    protected Document doGetDocument(TrashEntry trashEntry) {
        return null;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(String className, long classPK) {
    }

    protected void doReindex(String[] ids) {
    }

    protected void doReindex(TrashEntry trashEntry) {
    }
}

