/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashVersionLocalService;
import com.liferay.trash.service.TrashVersionLocalServiceUtil;
import com.liferay.trash.service.persistence.TrashVersionPersistence;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class TrashVersionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
TrashVersionLocalService {
    protected TrashVersionLocalService trashVersionLocalService;
    @Reference
    protected TrashVersionPersistence trashVersionPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(TrashVersionLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public TrashVersion addTrashVersion(TrashVersion trashVersion) {
        trashVersion.setNew(true);
        return (TrashVersion)this.trashVersionPersistence.update((BaseModel)trashVersion);
    }

    @Transactional(enabled=false)
    public TrashVersion createTrashVersion(long versionId) {
        return this.trashVersionPersistence.create(versionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public TrashVersion deleteTrashVersion(long versionId) throws PortalException {
        return this.trashVersionPersistence.remove(versionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public TrashVersion deleteTrashVersion(TrashVersion trashVersion) {
        return (TrashVersion)this.trashVersionPersistence.remove((BaseModel)trashVersion);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.trashVersionPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(TrashVersion.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.trashVersionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.trashVersionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.trashVersionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.trashVersionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.trashVersionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public TrashVersion fetchTrashVersion(long versionId) {
        return this.trashVersionPersistence.fetchByPrimaryKey(versionId);
    }

    public TrashVersion getTrashVersion(long versionId) throws PortalException {
        return this.trashVersionPersistence.findByPrimaryKey(versionId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.trashVersionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(TrashVersion.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("versionId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.trashVersionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(TrashVersion.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("versionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.trashVersionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(TrashVersion.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("versionId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.trashVersionPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement TrashVersionLocalServiceImpl#deleteTrashVersion(TrashVersion) to avoid orphaned data");
        }
        return this.trashVersionLocalService.deleteTrashVersion((TrashVersion)persistedModel);
    }

    public BasePersistence<TrashVersion> getBasePersistence() {
        return this.trashVersionPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.trashVersionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<TrashVersion> getTrashVersions(int start, int end) {
        return this.trashVersionPersistence.findAll(start, end);
    }

    public int getTrashVersionsCount() {
        return this.trashVersionPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public TrashVersion updateTrashVersion(TrashVersion trashVersion) {
        return (TrashVersion)this.trashVersionPersistence.update((BaseModel)trashVersion);
    }

    @Deactivate
    protected void deactivate() {
        TrashVersionLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{TrashVersionLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.trashVersionLocalService = (TrashVersionLocalService)aopProxy;
        TrashVersionLocalServiceUtil.setService((TrashVersionLocalService)this.trashVersionLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return TrashVersionLocalService.class.getName();
    }

    public CTPersistence<TrashVersion> getCTPersistence() {
        return this.trashVersionPersistence;
    }

    public Class<TrashVersion> getModelClass() {
        return TrashVersion.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<TrashVersion>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.trashVersionPersistence);
    }

    protected String getModelClassName() {
        return TrashVersion.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.trashVersionPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

