/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TrashHelper.class})
public class TrashHelperImpl
implements TrashHelper {
    private static final String _TRASH_PREFIX = "/";
    private static final Log _log = LogFactoryUtil.getLog(TrashHelperImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;

    public int getMaxAge(Group group) {
        int trashEntriesMaxAge = PrefsPropsUtil.getInteger((long)group.getCompanyId(), (String)"trash.entries.max.age", (int)PropsValues.TRASH_ENTRIES_MAX_AGE);
        UnicodeProperties typeSettingsUnicodeProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getInteger((String)typeSettingsUnicodeProperties.getProperty("trashEntriesMaxAge"), (int)trashEntriesMaxAge);
    }

    public String getNewName(ThemeDisplay themeDisplay, String className, long classPK, String oldName) throws PortalException {
        TrashRenderer trashRenderer = null;
        if (Validator.isNotNull((String)className) && classPK > 0L) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
            trashRenderer = trashHandler.getTrashRenderer(classPK);
        }
        StringBundler sb = new StringBundler(3);
        sb.append("(");
        Format format = FastDateFormatFactoryUtil.getDateTime((Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        sb.append(StringUtil.replace((String)format.format(new Date()), (char[])new char[]{'/', ':'}, (char[])new char[]{'.', '.'}));
        sb.append(")");
        if (trashRenderer != null) {
            return trashRenderer.getNewName(oldName, sb.toString());
        }
        return this._getNewName(oldName, sb.toString());
    }

    public String getOriginalTitle(String title) {
        return this._getOriginalTitle(title, "title", _TRASH_PREFIX);
    }

    public String getOriginalTitle(String title, String paramName) {
        return this._getOriginalTitle(title, paramName, _TRASH_PREFIX);
    }

    public TrashEntry getTrashEntry(TrashedModel trashedModel) throws PortalException {
        if (!trashedModel.isInTrash()) {
            return null;
        }
        BaseModel baseModel = (BaseModel)trashedModel;
        TrashEntry trashEntry = this._trashEntryLocalService.fetchEntry(baseModel.getModelClassName(), trashedModel.getTrashEntryClassPK());
        if (trashEntry != null) {
            return trashEntry;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)baseModel.getModelClassName());
        if (Validator.isNotNull((String)trashHandler.getContainerModelClassName(((Long)baseModel.getPrimaryKeyObj()).longValue()))) {
            ContainerModel containerModel = null;
            try {
                containerModel = trashHandler.getParentContainerModel(trashedModel);
            }
            catch (NoSuchModelException noSuchModelException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchModelException);
                }
                return null;
            }
            while (containerModel != null) {
                if (containerModel instanceof TrashedModel) {
                    return this.getTrashEntry((TrashedModel)containerModel);
                }
                if ((trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)trashHandler.getContainerModelClassName(containerModel.getContainerModelId()))) == null) {
                    return null;
                }
                containerModel = trashHandler.getContainerModel(containerModel.getParentContainerModelId());
            }
        }
        return null;
    }

    public String getTrashTitle(long entryId) {
        return this._getTrashTitle(entryId, _TRASH_PREFIX);
    }

    public PortletURL getViewContentURL(HttpServletRequest httpServletRequest, String className, long classPK) throws PortalException {
        TrashRenderer trashRenderer;
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        TrashedModel trashedModel = trashHandler.getTrashedModel(classPK);
        if (trashedModel != null && this.isInTrashContainer(trashedModel)) {
            TrashEntry trashEntry = this.getTrashEntry(trashedModel);
            className = trashEntry.getClassName();
            classPK = trashEntry.getClassPK();
            trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        }
        if ((trashRenderer = trashHandler.getTrashRenderer(classPK)) == null) {
            return null;
        }
        PortletURL portletURL = PortletURLBuilder.create((PortletURL)PortletProviderUtil.getPortletURL((HttpServletRequest)httpServletRequest, (String)TrashEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW)).setMVCPath("/view_content.jsp").setRedirect(() -> {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            return themeDisplay.getURLCurrent();
        }).buildPortletURL();
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(className, classPK);
        if (trashEntry.getRootEntry() != null) {
            portletURL.setParameter("className", className);
            portletURL.setParameter("classPK", String.valueOf(classPK));
        } else {
            portletURL.setParameter("trashEntryId", String.valueOf(trashEntry.getEntryId()));
        }
        portletURL.setParameter("showAssetMetadata", Boolean.TRUE.toString());
        return portletURL;
    }

    public boolean isInTrashContainer(TrashedModel trashedModel) {
        block6: {
            if (trashedModel == null) {
                return false;
            }
            BaseModel baseModel = (BaseModel)trashedModel;
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)baseModel.getModelClassName());
            if (trashHandler == null || Validator.isNull((String)trashHandler.getContainerModelClassName(((Long)baseModel.getPrimaryKeyObj()).longValue()))) {
                return false;
            }
            try {
                ContainerModel containerModel = trashHandler.getParentContainerModel(trashedModel);
                if (containerModel == null) {
                    return false;
                }
                if (containerModel instanceof TrashedModel) {
                    TrashedModel containerTrashedModel = (TrashedModel)containerModel;
                    return containerTrashedModel.isInTrash();
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)exception);
            }
        }
        return false;
    }

    public boolean isInTrashExplicitly(TrashedModel trashedModel) {
        if (!trashedModel.isInTrash()) {
            return false;
        }
        BaseModel baseModel = (BaseModel)trashedModel;
        TrashEntry trashEntry = this._trashEntryLocalService.fetchEntry(baseModel.getModelClassName(), trashedModel.getTrashEntryClassPK());
        return trashEntry != null;
    }

    public boolean isInTrashImplicitly(TrashedModel trashedModel) {
        if (!trashedModel.isInTrash()) {
            return false;
        }
        BaseModel baseModel = (BaseModel)trashedModel;
        TrashEntry trashEntry = this._trashEntryLocalService.fetchEntry(baseModel.getModelClassName(), trashedModel.getTrashEntryClassPK());
        return trashEntry == null;
    }

    public boolean isTrashEnabled(Group group) {
        boolean companyTrashEnabled = PrefsPropsUtil.getBoolean((long)group.getCompanyId(), (String)"trash.enabled");
        if (!companyTrashEnabled) {
            return false;
        }
        UnicodeProperties typeSettingsUnicodeProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("trashEnabled"), (boolean)true);
    }

    public boolean isTrashEnabled(long groupId) throws PortalException {
        return this.isTrashEnabled(this._groupLocalService.getGroup(groupId));
    }

    private String _getNewName(String oldName, String token) {
        return StringBundler.concat((String[])new String[]{oldName, " ", token});
    }

    private String _getOriginalTitle(String title, String paramName, String prefix) {
        block6: {
            if (!this._isValidTrashTitle(title, prefix)) {
                return title;
            }
            long trashEntryId = GetterUtil.getLong((String)(title = title.substring(prefix.length())));
            if (trashEntryId <= 0L) {
                return title;
            }
            try {
                TrashEntry trashEntry = this._trashEntryLocalService.fetchEntry(trashEntryId);
                if (trashEntry == null) {
                    TrashVersion trashVersion = this._trashVersionLocalService.getTrashVersion(trashEntryId);
                    title = trashVersion.getTypeSettingsProperty(paramName);
                } else {
                    title = trashEntry.getTypeSettingsProperty(paramName);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)("No trash entry or trash version exists with ID " + trashEntryId), (Throwable)exception);
            }
        }
        return title;
    }

    private String _getTrashTitle(long trashEntryId, String prefix) {
        return prefix.concat(String.valueOf(trashEntryId));
    }

    private boolean _isValidTrashTitle(String title, String prefix) {
        return title.startsWith(prefix);
    }
}

