/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.internal.search;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.model.TrashEntry;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DocumentContributor.class})
public class TrashedModelDocumentContributor
implements DocumentContributor<TrashedModel> {
    private static final Log _log = LogFactoryUtil.getLog(TrashedModelDocumentContributor.class);
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private UserLocalService _userLocalService;

    public void contribute(Document document, BaseModel<TrashedModel> baseModel) {
        block17: {
            TrashEntry trashEntry;
            TrashedModel trashedModel;
            block15: {
                if (baseModel == null || !(baseModel instanceof TrashedModel)) {
                    return;
                }
                trashedModel = (TrashedModel)baseModel;
                if (!trashedModel.isInTrash()) {
                    return;
                }
                trashEntry = null;
                try {
                    trashEntry = this._trashHelper.getTrashEntry(trashedModel);
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block15;
                    _log.debug((Object)("Unable to get trash entry for " + trashedModel), (Throwable)portalException);
                }
            }
            if (trashEntry == null) {
                document.addDate("removedDate", new Date());
                ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
                if (serviceContext != null) {
                    try {
                        User user = this._userLocalService.getUser(serviceContext.getUserId());
                        document.addKeyword("removedByUserName", user.getFullName(), true);
                    }
                    catch (PortalException portalException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Unable to locate user " + serviceContext.getUserId()), (Throwable)portalException);
                        }
                    }
                }
            } else {
                document.addDate("removedDate", trashEntry.getCreateDate());
                document.addKeyword("removedByUserName", trashEntry.getUserName(), true);
                if (trashedModel.isInTrash() && !this._trashHelper.isInTrashExplicitly(trashedModel)) {
                    document.addKeyword("rootEntryClassName", trashEntry.getClassName());
                    document.addKeyword("rootEntryClassPK", trashEntry.getClassPK());
                }
            }
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)baseModel.getModelClassName());
            try {
                TrashRenderer trashRenderer = null;
                if (trashHandler != null && trashEntry != null) {
                    trashRenderer = trashHandler.getTrashRenderer(trashEntry.getClassPK());
                }
                if (trashRenderer != null) {
                    document.addKeyword("type", trashRenderer.getType(), true);
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block17;
                _log.debug((Object)("Unable to get trash renderer for " + trashEntry.getClassName()), (Throwable)portalException);
            }
        }
    }
}

