/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.upload.configuration.UploadServletRequestConfigurationProvider;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.upload.UniqueFileNameProvider;
import java.util.function.Predicate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UniqueFileNameProvider.class})
public class DefaultUniqueFileNameProvider
implements UniqueFileNameProvider {
    @Reference
    private File _file;
    @Reference
    private UploadServletRequestConfigurationProvider _uploadServletRequestConfigurationProvider;

    public String provide(String fileName, Predicate<String> predicate) throws PortalException {
        String baseFileName;
        String uniqueFileName = baseFileName = this._file.stripParentheticalSuffix(fileName);
        int tries = 0;
        while (predicate.test(uniqueFileName)) {
            if ((long)tries >= this._uploadServletRequestConfigurationProvider.getMaxTries()) {
                throw new PortalException("Unable to get a unique file name for " + baseFileName);
            }
            uniqueFileName = FileUtil.appendParentheticalSuffix((String)baseFileName, (String)String.valueOf(++tries));
        }
        return uniqueFileName;
    }
}

