/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.upload.UploadResponseHandler;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, property={"upload.response.handler.system.default=true"}, service={UploadResponseHandler.class})
public class DefaultUploadResponseHandler
implements UploadResponseHandler {
    private volatile DLConfiguration _dlConfiguration;
    @Reference
    private Language _language;

    public JSONObject onFailure(PortletRequest portletRequest, PortalException portalException) throws PortalException {
        return JSONUtil.put((String)"error", () -> {
            if (!(portalException instanceof AntivirusScannerException || portalException instanceof FileExtensionException || portalException instanceof FileNameException || portalException instanceof FileSizeException || portalException instanceof UploadRequestSizeException)) {
                return null;
            }
            int errorType = 0;
            String message = "";
            if (portalException instanceof AntivirusScannerException) {
                errorType = 494;
                ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                AntivirusScannerException antivirusScannerException = (AntivirusScannerException)portalException;
                message = themeDisplay.translate(antivirusScannerException.getMessageKey());
            } else if (portalException instanceof FileExtensionException) {
                errorType = 491;
                message = this._getAllowedFileExtensions();
            } else if (portalException instanceof FileNameException) {
                errorType = 492;
            } else if (portalException instanceof FileSizeException) {
                errorType = 493;
                ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                FileSizeException fileSizeException = (FileSizeException)portalException;
                message = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{this._language.formatStorageSize((double)fileSizeException.getMaxSize(), themeDisplay.getLocale())});
            } else if (portalException instanceof UploadRequestSizeException) {
                errorType = 495;
            }
            return JSONUtil.put((String)"errorType", (Object)errorType).put("message", message);
        }).put("success", (Object)Boolean.FALSE);
    }

    public JSONObject onSuccess(UploadPortletRequest uploadPortletRequest, FileEntry fileEntry) throws PortalException {
        return JSONUtil.put((String)"file", (Object)JSONUtil.put((String)"attributeDataImageId", (Object)"data-image-id").put("fileEntryId", fileEntry.getFileEntryId()).put("groupId", fileEntry.getGroupId()).put("mimeType", fileEntry.getMimeType()).put("randomId", ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"randomId")).put("title", fileEntry.getTitle()).put("type", "document").put("url", () -> {
            ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            return PortletFileRepositoryUtil.getPortletFileEntryURL((ThemeDisplay)themeDisplay, (FileEntry)fileEntry, (String)"");
        }).put("uuid", fileEntry.getUuid())).put("success", (Object)Boolean.TRUE);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    private String _getAllowedFileExtensions() {
        Object[] allowedFileExtensions = this._dlConfiguration.fileExtensions();
        return StringUtil.merge((Object[])allowedFileExtensions, (String)", ");
    }
}

