/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.upload.UploadFileEntryHandler;
import com.liferay.upload.UploadHandler;
import com.liferay.upload.UploadResponseHandler;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UploadHandler.class})
public class DefaultUploadHandler
implements UploadHandler {
    @Reference
    private Portal _portal;

    public void upload(UploadFileEntryHandler uploadFileEntryHandler, UploadResponseHandler uploadResponseHandler, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        try {
            JSONObject responseJSONObject = this._getResponseJSONObject(uploadFileEntryHandler, uploadResponseHandler, portletRequest);
            JSONPortletResponseUtil.writeJSON((PortletRequest)portletRequest, (PortletResponse)portletResponse, (Object)responseJSONObject);
        }
        catch (IOException ioException) {
            throw new SystemException((Throwable)ioException);
        }
    }

    private JSONObject _getResponseJSONObject(UploadFileEntryHandler uploadFileEntryHandler, UploadResponseHandler uploadResponseHandler, PortletRequest portletRequest) throws IOException, PortalException {
        try {
            UploadPortletRequest uploadPortletRequest = this._getUploadPortletRequest(portletRequest);
            FileEntry fileEntry = uploadFileEntryHandler.upload(uploadPortletRequest);
            return uploadResponseHandler.onSuccess(uploadPortletRequest, fileEntry);
        }
        catch (PortalException portalException) {
            return uploadResponseHandler.onFailure(portletRequest, portalException);
        }
    }

    private UploadPortletRequest _getUploadPortletRequest(PortletRequest portletRequest) throws PortalException {
        UploadException uploadException = (UploadException)portletRequest.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            Throwable throwable = uploadException.getCause();
            if (uploadException.isExceededFileSizeLimit()) {
                throw new FileSizeException(throwable);
            }
            if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                throw new LiferayFileItemException(throwable);
            }
            if (uploadException.isExceededUploadRequestSizeLimit()) {
                throw new UploadRequestSizeException(throwable);
            }
            throw new PortalException(throwable);
        }
        return this._portal.getUploadPortletRequest(portletRequest);
    }
}

