/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.upload.web.internal;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.upload.AttachmentElementHandler;
import com.liferay.upload.AttachmentElementReplacer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"format=html", "html.tag.name=img"}, service={AttachmentElementHandler.class})
public class HTMLImageAttachmentElementHandler
implements AttachmentElementHandler {
    private static final String _ATTRIBUTE_LIST_REGEXP = "(?:\\s*?\\w+\\s*?=\\s*?\"[^\"]*\")*?\\s*?";
    private static final Pattern _tempAttachmentPattern;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(format=html)(html.tag.name=img))")
    private volatile AttachmentElementReplacer _attachmentElementReplacer;

    public String replaceAttachmentElements(String content, UnsafeFunction<FileEntry, FileEntry, PortalException> saveTempFileUnsafeFunction) throws PortalException {
        Matcher matcher = _tempAttachmentPattern.matcher(content);
        StringBuffer sb = new StringBuffer(content.length());
        while (matcher.find()) {
            FileEntry tempAttachmentFileEntry = this._getFileEntry(matcher);
            FileEntry attachmentFileEntry = (FileEntry)saveTempFileUnsafeFunction.apply((Object)tempAttachmentFileEntry);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this._attachmentElementReplacer.replace(matcher.group(0), attachmentFileEntry)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private FileEntry _getFileEntry(Matcher matcher) throws PortalException {
        long fileEntryId = GetterUtil.getLong((String)matcher.group(1));
        return PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
    }

    static {
        StringBundler sb = new StringBundler(8);
        sb.append("<\\s*?img");
        sb.append(_ATTRIBUTE_LIST_REGEXP);
        sb.append("data-image-id");
        sb.append("\\s*?=\\s*?\"");
        sb.append("([^\"]*)");
        sb.append("\"");
        sb.append(_ATTRIBUTE_LIST_REGEXP);
        sb.append("/>");
        _tempAttachmentPattern = Pattern.compile(sb.toString());
    }
}

