/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.user.associated.data.exporter;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactory;
import com.liferay.user.associated.data.exporter.UADExporter;
import com.liferay.user.associated.data.util.UADDynamicQueryUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;

public abstract class DynamicQueryUADExporter<T extends BaseModel>
implements UADExporter<T> {
    private static final Log _log = LogFactoryUtil.getLog(DynamicQueryUADExporter.class);

    @Override
    public long count(long userId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery(userId);
        return actionableDynamicQuery.performCount();
    }

    @Override
    public byte[] export(T baseModel) throws PortalException {
        String xml = this.toXmlString(baseModel);
        xml = this.formatXML(xml);
        try {
            return xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PortalException((Throwable)unsupportedEncodingException);
        }
    }

    @Override
    public File exportAll(long userId, ZipWriterFactory zipWriterFactory) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery(userId);
        ZipWriter zipWriter = this.getZipWriter(userId, this.getTypeKey(), zipWriterFactory);
        actionableDynamicQuery.setPerformActionMethod(baseModel -> {
            try {
                this.writeToZip(baseModel, zipWriter);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
        actionableDynamicQuery.performActions();
        return zipWriter.getFile();
    }

    protected File createFolder(long userId) {
        File file = new File(StringBundler.concat((Object[])new Object[]{SystemProperties.get((String)"java.io.tmpdir"), "/liferay/uad/", userId}));
        file.mkdirs();
        return file;
    }

    protected abstract ActionableDynamicQuery doGetActionableDynamicQuery();

    protected abstract String[] doGetUserIdFieldNames();

    protected String formatXML(String xml) {
        try {
            Document document = SAXReaderUtil.read((String)this._escapeCDATAClosingCharacters(xml));
            return document.formattedString();
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    protected ActionableDynamicQuery getActionableDynamicQuery(long userId) {
        return UADDynamicQueryUtil.addActionableDynamicQueryCriteria(this.doGetActionableDynamicQuery(), this.doGetUserIdFieldNames(), userId);
    }

    protected ZipWriter getZipWriter(long userId, String modelClassName, ZipWriterFactory zipWriterFactory) {
        File file = this.createFolder(userId);
        return zipWriterFactory.getZipWriter(new File(StringBundler.concat((String[])new String[]{file.getAbsolutePath(), "/", modelClassName, "_", Time.getShortTimestamp(), ".zip"})));
    }

    protected abstract String toXmlString(T var1);

    protected void writeToZip(T baseModel, ZipWriter zipWriter) throws Exception {
        byte[] data = this.export(baseModel);
        zipWriter.addEntry(baseModel.getPrimaryKeyObj() + ".xml", data);
    }

    private String _escapeCDATAClosingCharacters(String xml) {
        xml = StringUtil.replace((String)xml, (String)"]]><", (String)"[$SPECIAL_CHARACTER$]");
        xml = StringUtil.replace((String)xml, (String)"]]>", (String)"]]]]><![CDATA[>");
        return StringUtil.replace((String)xml, (String)"[$SPECIAL_CHARACTER$]", (String)"]]><");
    }
}

