/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class UserStagedModelDataHandler
extends BaseStagedModelDataHandler<User> {
    public static final String[] CLASS_NAMES = new String[]{User.class.getName()};
    private GroupLocalService _groupLocalService;
    private UserLocalService _userLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        User user = this._userLocalService.fetchUserByUuidAndCompanyId(uuid, group.getCompanyId());
        if (user != null) {
            this.deleteStagedModel(user);
        }
    }

    public void deleteStagedModel(User user) throws PortalException {
        this._userLocalService.deleteUser(user);
    }

    public List<User> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new User[]{this._userLocalService.fetchUserByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(User user) {
        return user.getFullName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, User user) {
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, User user) {
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

