/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class ListTypeStagedModelDataHandler
extends BaseStagedModelDataHandler<ListType> {
    public static final String[] CLASS_NAMES = new String[]{ListType.class.getName()};
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ListTypeLocalService _listTypeLocalService;

    public void deleteStagedModel(ListType listType) throws PortalException {
        this._listTypeLocalService.deleteListType(listType.getListTypeId());
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        ListType listType = this._listTypeLocalService.getListTypeByUuidAndCompanyId(uuid, group.getCompanyId());
        if (listType != null) {
            this.deleteStagedModel(listType);
        }
    }

    public List<ListType> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new ListType[]{this._listTypeLocalService.fetchListTypeByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, ListType listType) throws Exception {
        Element listTypeElement = portletDataContext.getExportDataElement((ClassedModel)listType);
        portletDataContext.addClassedModel(listTypeElement, ExportImportPathUtil.getModelPath((StagedModel)listType), (ClassedModel)listType);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, ListType listType) throws Exception {
        ListType existingListType = this._listTypeLocalService.getListType(portletDataContext.getCompanyId(), listType.getName(), listType.getType());
        if (existingListType == null) {
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)listType);
            serviceContext.setUuid(listType.getUuid());
            existingListType = this._listTypeLocalService.addListType(portletDataContext.getCompanyId(), listType.getName(), listType.getType());
        }
        portletDataContext.importClassedModel((ClassedModel)listType, (ClassedModel)existingListType);
    }
}

