/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.user.initials.generator;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.users.admin.kernel.util.UserInitialsGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UserInitialsGenerator.class})
public class UserInitialsGeneratorImpl
implements UserInitialsGenerator {
    private static final String[] _DEFAULT_USER_INITIALS_FIELD_NAMES = new String[]{"first-name", "last-name"};
    private static final Map<String, Integer> _userNameIndexes = HashMapBuilder.put((Object)"first-name", (Object)0).put((Object)"last-name", (Object)2).put((Object)"middle-name", (Object)1).build();
    @Reference
    private Language _language;
    private final Map<Locale, String[]> _userInitialsFieldNamesMap = new HashMap<Locale, String[]>();

    public String getInitials(Locale locale, String firstName, String middleName, String lastName) {
        String[] userNames = new String[]{firstName, middleName, lastName};
        List userNamesList = TransformUtil.transformToList((Object[])this._getUserInitialsFieldNames(locale), userInitialsFieldName -> userNames[_userNameIndexes.get(userInitialsFieldName)]);
        if (userNamesList.size() > 2) {
            userNamesList = userNamesList.subList(0, 2);
        }
        StringBundler sb = new StringBundler(userNamesList.size());
        for (String userName : userNamesList) {
            sb.append(StringUtil.toUpperCase((String)StringUtil.shorten((String)userName, (int)1)));
        }
        return sb.toString();
    }

    public String getInitials(User user) {
        return this.getInitials(user.getLocale(), user.getFirstName(), user.getMiddleName(), user.getLastName());
    }

    private String[] _getUserInitialsFieldNames(Locale locale) {
        Object[] userInitialsFieldNames = this._userInitialsFieldNamesMap.get(locale);
        if (userInitialsFieldNames != null) {
            return userInitialsFieldNames;
        }
        userInitialsFieldNames = StringUtil.split((String)this._language.get(locale, "lang.user.initials.field.names", null));
        if (ArrayUtil.isEmpty((Object[])userInitialsFieldNames)) {
            userInitialsFieldNames = _DEFAULT_USER_INITIALS_FIELD_NAMES;
        }
        this._userInitialsFieldNamesMap.put(locale, (String[])userInitialsFieldNames);
        return userInitialsFieldNames;
    }
}

