/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.test.util.search;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.users.admin.test.util.search.OrganizationBlueprint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrganizationSearchFixture {
    private final AssetTagLocalService _assetTagLocalService;
    private final List<AssetTag> _assetTags = new ArrayList<AssetTag>();
    private final OrganizationLocalService _organizationLocalService;
    private final List<Organization> _organizations = new ArrayList<Organization>();

    public static OrganizationBlueprint.OrganizationBlueprintBuilder getTestOrganizationBlueprintBuilder() {
        long userId = OrganizationSearchFixture.getTestUserId();
        OrganizationBlueprint.OrganizationBlueprintBuilder organizationBlueprintBuilder = new OrganizationBlueprint.OrganizationBlueprintBuilder();
        return organizationBlueprintBuilder.name(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).parentOrganizationId(0).site(false).userId(userId);
    }

    public OrganizationSearchFixture(OrganizationLocalService organizationLocalService) {
        this._organizationLocalService = organizationLocalService;
        this._assetTagLocalService = AssetTagLocalServiceUtil.getService();
    }

    public OrganizationSearchFixture(OrganizationLocalService organizationLocalService, AssetTagLocalService assetTagLocalService) {
        this._organizationLocalService = organizationLocalService;
        this._assetTagLocalService = assetTagLocalService;
    }

    public Organization addOrganization(OrganizationBlueprint organizationBlueprint) {
        Organization organization = this._addOrganization(organizationBlueprint);
        String[] assetTagNames = organizationBlueprint.getAssetTagNames();
        if (assetTagNames != null) {
            this._updateAsset(organization, assetTagNames);
        }
        this._organizations.add(organization);
        return organization;
    }

    public List<AssetTag> getAssetTags() {
        return this._assetTags;
    }

    public List<Organization> getOrganizations() {
        return Collections.unmodifiableList(this._organizations);
    }

    protected static long getTestUserId() {
        try {
            return TestPropsValues.getUserId();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private Organization _addOrganization(OrganizationBlueprint organizationBlueprint) {
        try {
            return this._organizationLocalService.addOrganization(organizationBlueprint.getUserId(), (long)organizationBlueprint.getParentOrganizationId(), organizationBlueprint.getName(), organizationBlueprint.isSite());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void _updateAsset(Organization organization, String[] assetTagNames) {
        try {
            this._organizationLocalService.updateAsset(organization.getUserId(), organization, null, assetTagNames);
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
        List assetTags = this._assetTagLocalService.getTags(organization.getModelClassName(), organization.getPrimaryKey());
        this._assetTags.addAll(assetTags);
    }
}

