/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTracker;
import com.liferay.portal.kernel.service.UserTrackerLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import com.liferay.users.admin.uad.constants.UsersAdminUADConstants;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseUserTrackerUADAnonymizer
extends DynamicQueryUADAnonymizer<UserTracker> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected UserTrackerLocalService userTrackerLocalService;

    public void autoAnonymize(UserTracker userTracker, long userId, User anonymousUser) throws PortalException {
        if (userTracker.getUserId() == userId) {
            this.delete(userTracker);
            this.autoAnonymizeAssetEntry(userTracker, anonymousUser);
        }
    }

    public void delete(UserTracker userTracker) throws PortalException {
        this.userTrackerLocalService.deleteUserTracker(userTracker);
    }

    public Class<UserTracker> getTypeClass() {
        return UserTracker.class;
    }

    protected void autoAnonymizeAssetEntry(UserTracker userTracker, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(userTracker);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.userTrackerLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return UsersAdminUADConstants.USER_ID_FIELD_NAMES_USER_TRACKER;
    }

    protected AssetEntry fetchAssetEntry(UserTracker userTracker) {
        return this.assetEntryLocalService.fetchEntry(UserTracker.class.getName(), userTracker.getUserTrackerId());
    }
}

