/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.view.count.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.view.count.model.ViewCountEntry;
import com.liferay.view.count.model.impl.ViewCountEntryImpl;
import com.liferay.view.count.service.persistence.ViewCountEntryFinder;
import com.liferay.view.count.service.persistence.ViewCountEntryPK;
import com.liferay.view.count.service.persistence.impl.ViewCountEntryFinderBaseImpl;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ViewCountEntryFinder.class})
public class ViewCountEntryFinderImpl
extends ViewCountEntryFinderBaseImpl
implements ViewCountEntryFinder {
    @Reference
    private EntityCache _entityCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementViewCount(long companyId, long classNameId, long classPK, int increment) {
        Session session = null;
        try {
            session = this.openSession();
            ViewCountEntryPK viewCountEntryPK = new ViewCountEntryPK(companyId, classNameId, classPK);
            ViewCountEntry viewCountEntry = (ViewCountEntry)session.get(ViewCountEntryImpl.class, (Serializable)viewCountEntryPK, LockMode.UPGRADE);
            if (viewCountEntry == null) {
                viewCountEntry = new ViewCountEntryImpl();
                viewCountEntry.setPrimaryKey(viewCountEntryPK);
                viewCountEntry.setViewCount((long)increment);
                session.save((Object)viewCountEntry);
                session.flush();
            } else {
                viewCountEntry.setViewCount(viewCountEntry.getViewCount() + (long)increment);
                session.saveOrUpdate((Object)viewCountEntry);
            }
            this._entityCache.putResult(ViewCountEntryImpl.class, (Serializable)viewCountEntryPK, (Serializable)viewCountEntry);
        }
        finally {
            this.closeSession(session);
        }
    }
}

