/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.websocket.whiteboard.internal;

import com.liferay.websocket.whiteboard.internal.ServiceObjectsConfigurator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ServerEndpointConfigWrapper
implements ServerEndpointConfig {
    private final ServerEndpointConfig.Configurator _configurator = new ServerEndpointConfig.Configurator(){

        public <T> T getEndpointInstance(Class<T> endpointClass) {
            return (T)((Object)new NullEndpoint());
        }
    };
    private ConcurrentNavigableMap<ServiceReference<Endpoint>, ServiceObjectsConfigurator> _endpoints;
    private final LogService _logService;
    private ServerEndpointConfig _serverEndpointConfig;

    public ServerEndpointConfigWrapper(String path, List<Class<? extends Decoder>> decoders, List<Class<? extends Encoder>> encoders, List<String> subprotocols, LogService logService) {
        this._logService = logService;
        this._init(path, decoders, encoders, subprotocols);
    }

    public ServerEndpointConfig.Configurator getConfigurator() {
        Map.Entry entry = this._endpoints.firstEntry();
        if (entry == null) {
            return this._configurator;
        }
        return (ServerEndpointConfig.Configurator)entry.getValue();
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this._serverEndpointConfig.getDecoders();
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this._serverEndpointConfig.getEncoders();
    }

    public Class<?> getEndpointClass() {
        return this._serverEndpointConfig.getEndpointClass();
    }

    public List<Extension> getExtensions() {
        return this._serverEndpointConfig.getExtensions();
    }

    public String getPath() {
        return this._serverEndpointConfig.getPath();
    }

    public List<String> getSubprotocols() {
        return this._serverEndpointConfig.getSubprotocols();
    }

    public Map<String, Object> getUserProperties() {
        return this._serverEndpointConfig.getUserProperties();
    }

    public void override(List<Class<? extends Decoder>> decoders, List<Class<? extends Encoder>> encoders, List<String> subprotocols) {
        this._init(this._serverEndpointConfig.getPath(), decoders, encoders, subprotocols);
    }

    public ServiceObjectsConfigurator removeConfigurator(ServiceReference<Endpoint> serviceReference) {
        return (ServiceObjectsConfigurator)((Object)this._endpoints.remove(serviceReference));
    }

    public void setConfigurator(ServiceReference<Endpoint> serviceReference, ServiceObjectsConfigurator serviceObjectsConfigurator) {
        this._endpoints.put(serviceReference, serviceObjectsConfigurator);
    }

    private void _init(String path, List<Class<? extends Decoder>> decoders, List<Class<? extends Encoder>> encoders, List<String> subprotocols) {
        ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(Endpoint.class, (String)path);
        builder.decoders(decoders);
        builder.encoders(encoders);
        builder.subprotocols(subprotocols);
        this._serverEndpointConfig = builder.build();
        this._endpoints = new ConcurrentSkipListMap<ServiceReference<Endpoint>, ServiceObjectsConfigurator>();
    }

    public final class NullEndpoint
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Service is gone away"));
            }
            catch (IOException ioException) {
                ServerEndpointConfigWrapper.this._logService.log(1, "Unable to close session", (Throwable)ioException);
            }
        }
    }
}

