/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.websocket.whiteboard.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.websocket.whiteboard.internal.ServerEndpointConfigWrapper;
import com.liferay.websocket.whiteboard.internal.ServiceObjectsConfigurator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class WebSocketEndpointTracker {
    private static final Log _log = LogFactoryUtil.getLog(WebSocketEndpointTracker.class);
    @Reference
    private LogService _logService;
    private final ConcurrentMap<String, ServerEndpointConfigWrapper> _serverEndpointConfigWrappers = new ConcurrentHashMap<String, ServerEndpointConfigWrapper>();
    private ServiceTracker<Endpoint, ServerEndpointConfigWrapper> _serverEndpointConfigWrapperServiceTracker;
    @Reference(target="(original.bean=true)")
    private ServletContext _servletContext;

    @Activate
    protected void activate(final BundleContext bundleContext) {
        Object serverContainer = this._servletContext.getAttribute("javax.websocket.server.ServerContainer");
        if (serverContainer == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"A WebSocket server container is not registered");
            }
            return;
        }
        this._serverEndpointConfigWrapperServiceTracker = new ServiceTracker(bundleContext, Endpoint.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Endpoint, ServerEndpointConfigWrapper>(){

            public ServerEndpointConfigWrapper addingService(ServiceReference<Endpoint> serviceReference) {
                String path = (String)serviceReference.getProperty("org.osgi.http.websocket.endpoint.path");
                if (path == null || path.isEmpty()) {
                    return null;
                }
                List decoders = (List)serviceReference.getProperty("org.osgi.http.websocket.endpoint.decoders");
                List encoders = (List)serviceReference.getProperty("org.osgi.http.websocket.endpoint.encoders");
                List subprotocol = (List)serviceReference.getProperty("org.osgi.http.websocket.endpoint.subprotocol");
                ServiceObjects serviceObjects = bundleContext.getServiceObjects(serviceReference);
                ServerEndpointConfigWrapper serverEndpointConfigWrapper = (ServerEndpointConfigWrapper)WebSocketEndpointTracker.this._serverEndpointConfigWrappers.get(path);
                boolean isNew = false;
                if (serverEndpointConfigWrapper == null) {
                    serverEndpointConfigWrapper = new ServerEndpointConfigWrapper(path, decoders, encoders, subprotocol, WebSocketEndpointTracker.this._logService);
                    isNew = true;
                } else {
                    Class<?> endpointClass = serverEndpointConfigWrapper.getEndpointClass();
                    ServerEndpointConfig.Configurator configurator = serverEndpointConfigWrapper.getConfigurator();
                    try {
                        Object endpointInstance = configurator.getEndpointInstance(endpointClass);
                        Class<?> endpointInstanceClass = endpointInstance.getClass();
                        if (endpointInstanceClass.equals(ServerEndpointConfigWrapper.NullEndpoint.class)) {
                            serverEndpointConfigWrapper.override(decoders, encoders, subprotocol);
                        }
                    }
                    catch (InstantiationException instantiationException) {
                        Endpoint endpoint = (Endpoint)serviceObjects.getService();
                        WebSocketEndpointTracker.this._logService.log(1, StringBundler.concat((Object[])new Object[]{"Unable to register WebSocket endpoint ", endpoint.getClass(), " for path ", path}), (Throwable)instantiationException);
                    }
                }
                serverEndpointConfigWrapper.setConfigurator(serviceReference, new ServiceObjectsConfigurator((ServiceObjects<Endpoint>)serviceObjects, WebSocketEndpointTracker.this._logService));
                if (isNew) {
                    ServerContainer serverContainer = (ServerContainer)WebSocketEndpointTracker.this._servletContext.getAttribute(ServerContainer.class.getName());
                    try {
                        serverContainer.addEndpoint((ServerEndpointConfig)serverEndpointConfigWrapper);
                    }
                    catch (DeploymentException deploymentException) {
                        Endpoint endpoint = (Endpoint)serviceObjects.getService();
                        WebSocketEndpointTracker.this._logService.log(1, StringBundler.concat((Object[])new Object[]{"Unable to register WebSocket endpoint ", endpoint.getClass(), " for path ", path}), (Throwable)deploymentException);
                        return null;
                    }
                    WebSocketEndpointTracker.this._serverEndpointConfigWrappers.put(path, serverEndpointConfigWrapper);
                }
                return serverEndpointConfigWrapper;
            }

            public void modifiedService(ServiceReference<Endpoint> serviceReference, ServerEndpointConfigWrapper serverEndpointConfigWrapper) {
                this.removedService(serviceReference, serverEndpointConfigWrapper);
                this.addingService((ServiceReference)serviceReference);
            }

            public void removedService(ServiceReference<Endpoint> serviceReference, ServerEndpointConfigWrapper serverEndpointConfigWrapper) {
                ServiceObjectsConfigurator serviceObjectsConfigurator = serverEndpointConfigWrapper.removeConfigurator(serviceReference);
                serviceObjectsConfigurator.close();
            }
        });
        this._serverEndpointConfigWrapperServiceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        if (this._serverEndpointConfigWrapperServiceTracker != null) {
            this._serverEndpointConfigWrapperServiceTracker.close();
        }
    }
}

