/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.agent;

import com.liferay.whip.coveragedata.ClassData;
import com.liferay.whip.coveragedata.LineData;
import com.liferay.whip.coveragedata.ProjectData;
import com.liferay.whip.coveragedata.ProjectDataUtil;
import com.liferay.whip.instrument.WhipClassFileTransformer;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;

public class InstrumentationAgent {
    private static final File _dataFile = new File(System.getProperty("whip.datafile"));
    private static boolean _dynamicallyInstrumented;
    private static String[] _excludes;
    private static String[] _includes;
    private static Instrumentation _instrumentation;
    private static final File _lockFile;
    private static List<OriginalClassDefinition> _originalClassDefinitions;
    private static WhipClassFileTransformer _whipClassFileTransformer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void assertCoverage(boolean includeInnerClasses, List<Class<?>> classes, List<Method> methods) {
        if (!_dynamicallyInstrumented) {
            return;
        }
        _instrumentation.removeTransformer(_whipClassFileTransformer);
        _whipClassFileTransformer = null;
        try {
            ProjectData projectData = ProjectDataUtil.captureProjectData(false, false);
            ArrayList<AssertionError> assertionErrors = new ArrayList<AssertionError>();
            for (Class<?> clazz : classes) {
                Class<?>[] declaredClasses;
                if (clazz.isSynthetic()) continue;
                ClassData classData = projectData.getClassData(clazz.getName());
                InstrumentationAgent._assertClassDataCoverage(assertionErrors, classData);
                if (!includeInnerClasses) continue;
                block8: for (Class<?> declaredClass : declaredClasses = clazz.getDeclaredClasses()) {
                    if (declaredClass.isSynthetic()) continue;
                    for (Class<?> clazz2 : classes) {
                        if (!clazz2.equals(declaredClass)) continue;
                        continue block8;
                    }
                    classData = projectData.getClassData(declaredClass.getName());
                    InstrumentationAgent._assertClassDataCoverage(assertionErrors, classData);
                }
            }
            for (Method method : methods) {
                Class<?> clazz = method.getDeclaringClass();
                InstrumentationAgent._assertMethodCoverage(assertionErrors, projectData.getClassData(clazz.getName()), method);
            }
            if (!assertionErrors.isEmpty()) {
                AssertionError assertionError = (AssertionError)assertionErrors.get(0);
                for (int i = 1; i < assertionErrors.size(); ++i) {
                    ((Throwable)((Object)assertionError)).addSuppressed((Throwable)assertionErrors.get(i));
                }
                throw assertionError;
            }
        }
        finally {
            _dynamicallyInstrumented = false;
            if (_originalClassDefinitions != null) {
                try {
                    ArrayList<ClassDefinition> classDefinitions = new ArrayList<ClassDefinition>(_originalClassDefinitions.size());
                    for (OriginalClassDefinition originalClassDefinition : _originalClassDefinitions) {
                        ClassDefinition classDefinition = originalClassDefinition.toClassDefinition();
                        if (classDefinition == null) continue;
                        classDefinitions.add(classDefinition);
                    }
                    _originalClassDefinitions = null;
                    _instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[0]));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to uninstrument classes", exception);
                }
            }
        }
    }

    public static synchronized void dynamicallyInstrument(String[] includes, String[] excludes) throws UnmodifiableClassException {
        String agentLine;
        int index;
        if (_instrumentation == null || _dynamicallyInstrumented) {
            return;
        }
        if (includes == null) {
            includes = _includes;
        }
        if (excludes == null) {
            excludes = _excludes;
        }
        if ((index = (agentLine = System.getProperty("whip.agent")).indexOf(61)) != -1) {
            StringBuilder sb = new StringBuilder();
            sb.append(agentLine, 0, index + 1);
            for (String include : includes) {
                sb.append(include);
                sb.append(',');
            }
            if (includes.length > 0) {
                sb.setLength(sb.length() - 1);
            }
            sb.append(';');
            for (String exclude : excludes) {
                sb.append(exclude);
                sb.append(',');
            }
            if (excludes.length > 0) {
                sb.setLength(sb.length() - 1);
            }
            System.setProperty("whip.agent", sb.toString());
        }
        if (_whipClassFileTransformer == null) {
            _whipClassFileTransformer = new WhipClassFileTransformer(includes, excludes);
        }
        _instrumentation.addTransformer(_whipClassFileTransformer, true);
        Class[] allLoadedClasses = _instrumentation.getAllLoadedClasses();
        ArrayList<Class> modifiableClasses = new ArrayList<Class>();
        for (Class loadedClass : allLoadedClasses) {
            if (!_instrumentation.isModifiableClass(loadedClass)) continue;
            String className = loadedClass.getName();
            if (!_whipClassFileTransformer.matches(className = className.replace('.', '/'))) continue;
            modifiableClasses.add(loadedClass);
        }
        _instrumentation.retransformClasses(modifiableClasses.toArray(new Class[0]));
        _dynamicallyInstrumented = true;
        _originalClassDefinitions = null;
    }

    public static File getDataFile() {
        return _dataFile;
    }

    public static File getLockFile() {
        return _lockFile;
    }

    public static synchronized void premain(String agentArguments, Instrumentation instrumentation) {
        String[] arguments = agentArguments.split(";");
        String[] includes = arguments[0].split(",");
        String[] excludes = arguments[1].split(",");
        if (Boolean.getBoolean("whip.static.instrument")) {
            WhipClassFileTransformer whipClassFileTransformer = new WhipClassFileTransformer(includes, excludes);
            instrumentation.addTransformer(whipClassFileTransformer);
            Runtime runtime = Runtime.getRuntime();
            runtime.addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ProjectDataUtil.captureProjectData(true, Boolean.getBoolean("whip.static.instrument.use.data.file"));
                }
            });
        } else if (instrumentation.isRedefineClassesSupported() && instrumentation.isRetransformClassesSupported()) {
            _instrumentation = instrumentation;
            _includes = includes;
            _excludes = excludes;
            _dataFile.delete();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Current JVM is not capable for dynamic ");
            sb.append("instrumententation. Instrumentation ");
            if (instrumentation.isRetransformClassesSupported()) {
                sb.append("supports ");
            } else {
                sb.append("does not support ");
            }
            sb.append("restranforming classes. Instrumentation ");
            if (instrumentation.isRedefineClassesSupported()) {
                sb.append("supports ");
            } else {
                sb.append("does not support ");
            }
            sb.append("redefining classes. Dynamic instrumententation is ");
            sb.append("disabled.");
            System.out.println(sb.toString());
        }
    }

    public static synchronized void recordInstrumentation(ClassLoader classLoader, String name, byte[] bytes) {
        if (!_dynamicallyInstrumented) {
            return;
        }
        if (_originalClassDefinitions == null) {
            _originalClassDefinitions = new ArrayList<OriginalClassDefinition>();
        }
        OriginalClassDefinition originalClassDefinition = new OriginalClassDefinition(classLoader, name, bytes);
        _originalClassDefinitions.add(originalClassDefinition);
    }

    private static void _assertClassDataCoverage(List<AssertionError> assertionErrors, ClassData classData) {
        if (classData.getBranchCoverageRate() != 1.0 || classData.getLineCoverageRate() != 1.0) {
            StringBuilder sb = new StringBuilder();
            sb.append("%n[Whip] %s is not fully covered.%n[Whip]Branch ");
            sb.append("coverage rate : %.2f, line coverage rate : ");
            sb.append("%.2f.%n");
            System.out.printf(sb.toString(), classData.getName(), classData.getBranchCoverageRate(), classData.getLineCoverageRate());
            for (LineData lineData : classData.getLines()) {
                if (lineData.isCovered()) continue;
                System.out.printf("[Whip] %s line %d is not covered %n", classData.getName(), lineData.getLineNumber());
            }
            assertionErrors.add(new AssertionError((Object)(classData.getName() + " is not fully covered")));
            return;
        }
        System.out.printf("[Whip] %s is fully covered.%n", classData.getName());
    }

    private static void _assertMethodCoverage(List<AssertionError> assertionErrors, ClassData classData, Method method) {
        boolean hasUncoveredLines = false;
        for (LineData lineData : classData.getLines()) {
            String methodDescriptor;
            String methodName;
            if (lineData.isCovered() || !(methodName = lineData.getMethodName()).equals(method.getName()) || !(methodDescriptor = Type.getMethodDescriptor((Method)method)).equals(lineData.getMethodDescriptor())) continue;
            hasUncoveredLines = true;
            System.out.printf("[Whip] %s line %d is not covered %n", method, lineData.getLineNumber());
        }
        if (hasUncoveredLines) {
            assertionErrors.add(new AssertionError((Object)(method + " is not fully covered")));
        }
    }

    static {
        File parentFolder = _dataFile.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        _lockFile = new File(parentFolder, "lock");
        try {
            _lockFile.createNewFile();
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
    }

    private static class OriginalClassDefinition {
        private final byte[] _bytes;
        private final ClassLoader _classLoader;
        private final String _className;

        public ClassDefinition toClassDefinition() {
            try {
                Class<?> clazz = Class.forName(this._className, true, this._classLoader);
                return new ClassDefinition(clazz, this._bytes);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private OriginalClassDefinition(ClassLoader classLoader, String className, byte[] bytes) {
            this._classLoader = classLoader;
            this._bytes = bytes;
            this._className = className.replace('/', '.');
        }
    }
}

