/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.coveragedata;

import com.liferay.whip.coveragedata.CoverageDataContainer;
import com.liferay.whip.coveragedata.JumpData;
import com.liferay.whip.coveragedata.LineData;
import com.liferay.whip.coveragedata.SwitchData;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class ClassData
extends CoverageDataContainer<Integer, LineData, ClassData> {
    private static final long serialVersionUID = 1L;
    private final String _name;

    public ClassData(String name) {
        this._name = name;
    }

    public LineData addLine(String methodName, String methodDescriptor, int lineNumber) {
        LineData lineData = new LineData(this._name, methodName, methodDescriptor, lineNumber);
        LineData previousLineData = this.children.putIfAbsent(lineData.getLineNumber(), lineData);
        if (previousLineData == null) {
            return lineData;
        }
        return previousLineData;
    }

    public void addLineJump(int lineNumber, int branchNumber) {
        LineData lineData = this._getLineData(lineNumber);
        lineData.addJump(new JumpData(this._name, lineNumber, branchNumber));
    }

    public void addLineSwitch(int lineNumber, int switchNumber, int min, int max) {
        LineData lineData = this._getLineData(lineNumber);
        lineData.addSwitch(new SwitchData(this._name, lineNumber, switchNumber, max - min + 1));
    }

    public void addLineSwitch(int lineNumber, int switchNumber, int[] keys) {
        LineData lineData = this._getLineData(lineNumber);
        lineData.addSwitch(new SwitchData(this._name, lineNumber, switchNumber, keys.length));
    }

    public Set<LineData> getLines() {
        TreeSet<LineData> set = new TreeSet<LineData>(new Comparator<LineData>(){

            @Override
            public int compare(LineData lineData1, LineData lineData2) {
                return lineData1.getLineNumber() - lineData2.getLineNumber();
            }
        });
        set.addAll(this.children.values());
        return set;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public int getNumberOfCoveredBranches() {
        int numberOfCoveredBranches = 0;
        for (LineData lineData : this.children.values()) {
            numberOfCoveredBranches += lineData.getNumberOfCoveredBranches();
        }
        return numberOfCoveredBranches;
    }

    @Override
    public int getNumberOfValidBranches() {
        int numberOfValidBranches = 0;
        for (LineData lineData : this.children.values()) {
            numberOfValidBranches += lineData.getNumberOfValidBranches();
        }
        return numberOfValidBranches;
    }

    @Override
    public void merge(ClassData classData) {
        if (!this._name.equals(classData._name)) {
            throw new IllegalArgumentException("Class data mismatch, left : " + this._name + ", right : " + classData._name);
        }
        super.merge(classData);
    }

    public void touch(int lineNumber) {
        LineData lineData = this._getLineData(lineNumber);
        lineData.touch();
    }

    public void touchJump(int lineNumber, int branchNumber, boolean branch) {
        LineData lineData = this._getLineData(lineNumber);
        lineData.touchJump(branchNumber, branch);
    }

    public void touchSwitch(int lineNumber, int switchNumber, int branch) {
        LineData lineData = this._getLineData(lineNumber);
        lineData.touchSwitch(switchNumber, branch);
    }

    private LineData _getLineData(int lineNumber) {
        LineData lineData = (LineData)this.children.get(lineNumber);
        if (lineData == null) {
            throw new IllegalStateException("No instrument data for class " + this._name + " line " + lineNumber);
        }
        return lineData;
    }
}

