/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.coveragedata;

import com.liferay.whip.coveragedata.CoverageData;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class CoverageDataContainer<K, V extends CoverageData<V>, T extends CoverageDataContainer<K, V, T>>
implements CoverageData<T>,
Serializable {
    protected final ConcurrentMap<K, V> children = new ConcurrentHashMap();
    private static final long serialVersionUID = 1L;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CoverageDataContainer)) {
            return false;
        }
        CoverageDataContainer coverageDataContainer = (CoverageDataContainer)object;
        return this.children.equals(coverageDataContainer.children);
    }

    @Override
    public double getBranchCoverageRate() {
        int numberOfCoveredBranches = 0;
        int numberOfValidBranches = 0;
        for (CoverageData coverageData : this.children.values()) {
            numberOfCoveredBranches += coverageData.getNumberOfCoveredBranches();
            numberOfValidBranches += coverageData.getNumberOfValidBranches();
        }
        if (numberOfValidBranches == 0) {
            return 1.0;
        }
        return (double)numberOfCoveredBranches / (double)numberOfValidBranches;
    }

    @Override
    public double getLineCoverageRate() {
        int numberOfCoveredLines = 0;
        int numberOfValidLines = 0;
        for (CoverageData coverageData : this.children.values()) {
            numberOfCoveredLines += coverageData.getNumberOfCoveredLines();
            numberOfValidLines += coverageData.getNumberOfValidLines();
        }
        if (numberOfValidLines == 0) {
            return 1.0;
        }
        return (double)numberOfCoveredLines / (double)numberOfValidLines;
    }

    @Override
    public int getNumberOfCoveredBranches() {
        int numberOfCoveredBranches = 0;
        for (CoverageData coverageData : this.children.values()) {
            numberOfCoveredBranches += coverageData.getNumberOfCoveredBranches();
        }
        return numberOfCoveredBranches;
    }

    @Override
    public int getNumberOfCoveredLines() {
        int numberOfCoveredLines = 0;
        for (CoverageData coverageData : this.children.values()) {
            numberOfCoveredLines += coverageData.getNumberOfCoveredLines();
        }
        return numberOfCoveredLines;
    }

    @Override
    public int getNumberOfValidBranches() {
        int numberOfValidBranches = 0;
        for (CoverageData coverageData : this.children.values()) {
            numberOfValidBranches += coverageData.getNumberOfValidBranches();
        }
        return numberOfValidBranches;
    }

    @Override
    public int getNumberOfValidLines() {
        int numberOfValidLines = 0;
        for (CoverageData coverageData : this.children.values()) {
            numberOfValidLines += coverageData.getNumberOfValidLines();
        }
        return numberOfValidLines;
    }

    public int hashCode() {
        return this.children.hashCode();
    }

    @Override
    public void merge(T otherCoverageDataContainer) {
        ConcurrentMap<K, V> otherChildren = ((CoverageDataContainer)otherCoverageDataContainer).children;
        for (Map.Entry entry : otherChildren.entrySet()) {
            CoverageData otherChildCoverageData = (CoverageData)entry.getValue();
            CoverageData myChildCoverageData = this.children.putIfAbsent(entry.getKey(), otherChildCoverageData);
            if (myChildCoverageData == null) continue;
            myChildCoverageData.merge(otherChildCoverageData);
        }
    }
}

