/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.coveragedata;

import com.liferay.whip.coveragedata.BranchCoverageData;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class JumpData
implements BranchCoverageData<JumpData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _className;
    private final AtomicLong _falseHitCounter = new AtomicLong();
    private final int _jumpNumber;
    private final int _lineNumber;
    private final AtomicLong _trueHitCounter = new AtomicLong();

    public JumpData(String className, int lineNumber, int jumpNumber) {
        this._className = className;
        this._lineNumber = lineNumber;
        this._jumpNumber = jumpNumber;
    }

    @Override
    public double getBranchCoverageRate() {
        return (double)this.getNumberOfCoveredBranches() / (double)this.getNumberOfValidBranches();
    }

    public int getJumpNumber() {
        return this._jumpNumber;
    }

    @Override
    public int getNumberOfCoveredBranches() {
        int numberOfCoveredBranches = 0;
        if (this._trueHitCounter.get() > 0L) {
            ++numberOfCoveredBranches;
        }
        if (this._falseHitCounter.get() > 0L) {
            ++numberOfCoveredBranches;
        }
        return numberOfCoveredBranches;
    }

    @Override
    public int getNumberOfValidBranches() {
        return 2;
    }

    @Override
    public void merge(JumpData jumpData) {
        if (!this._className.equals(jumpData._className) || this._lineNumber != jumpData._lineNumber || this._jumpNumber != jumpData._jumpNumber) {
            throw new IllegalArgumentException("Jump data mismatch, left : " + this.toString() + ", right : " + jumpData);
        }
        AtomicLong trueHitCounter = jumpData._trueHitCounter;
        this._trueHitCounter.addAndGet(trueHitCounter.get());
        AtomicLong falseHitCounter = jumpData._falseHitCounter;
        this._falseHitCounter.addAndGet(falseHitCounter.get());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{className=");
        sb.append(this._className);
        sb.append(", lineNumber=");
        sb.append(this._lineNumber);
        sb.append(", jumpNumber=");
        sb.append(this._jumpNumber);
        sb.append("}");
        return sb.toString();
    }

    public void touchBranch(boolean branch) {
        if (branch) {
            this._trueHitCounter.incrementAndGet();
        } else {
            this._falseHitCounter.incrementAndGet();
        }
    }
}

