/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.coveragedata;

import com.liferay.whip.coveragedata.CoverageData;
import com.liferay.whip.coveragedata.JumpData;
import com.liferay.whip.coveragedata.SwitchData;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class LineData
implements CoverageData<LineData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _className;
    private final AtomicLong _hitCounter = new AtomicLong();
    private final ConcurrentMap<Integer, JumpData> _jumpDatas = new ConcurrentHashMap<Integer, JumpData>();
    private final int _lineNumber;
    private final String _methodDescriptor;
    private final String _methodName;
    private final ConcurrentMap<Integer, SwitchData> _switchDatas = new ConcurrentHashMap<Integer, SwitchData>();

    public LineData(String className, String methodName, String methodDescriptor, int lineNumber) {
        this._className = className;
        this._methodName = methodName;
        this._methodDescriptor = methodDescriptor;
        this._lineNumber = lineNumber;
    }

    public JumpData addJump(JumpData jumpData) {
        JumpData previousJumpData = this._jumpDatas.putIfAbsent(jumpData.getJumpNumber(), jumpData);
        if (previousJumpData != null) {
            return previousJumpData;
        }
        return jumpData;
    }

    public SwitchData addSwitch(SwitchData switchData) {
        SwitchData previousSwitchData = this._switchDatas.putIfAbsent(switchData.getSwitchNumber(), switchData);
        if (previousSwitchData != null) {
            return previousSwitchData;
        }
        return switchData;
    }

    @Override
    public double getBranchCoverageRate() {
        int numberOfValidBranches = this.getNumberOfValidBranches();
        if (numberOfValidBranches == 0) {
            return 1.0;
        }
        return (double)this.getNumberOfCoveredBranches() / (double)numberOfValidBranches;
    }

    @Override
    public double getLineCoverageRate() {
        return this.getNumberOfCoveredLines();
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getMethodDescriptor() {
        return this._methodDescriptor;
    }

    public String getMethodName() {
        return this._methodName;
    }

    @Override
    public int getNumberOfCoveredBranches() {
        int numberOfCoveredBranches = 0;
        for (JumpData jumpData : this._jumpDatas.values()) {
            numberOfCoveredBranches += jumpData.getNumberOfCoveredBranches();
        }
        for (SwitchData switchData : this._switchDatas.values()) {
            numberOfCoveredBranches += switchData.getNumberOfCoveredBranches();
        }
        return numberOfCoveredBranches;
    }

    @Override
    public int getNumberOfCoveredLines() {
        if (this._hitCounter.get() > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getNumberOfValidBranches() {
        int numberOfValidBranches = 0;
        for (JumpData jumpData : this._jumpDatas.values()) {
            numberOfValidBranches += jumpData.getNumberOfValidBranches();
        }
        for (SwitchData switchData : this._switchDatas.values()) {
            numberOfValidBranches += switchData.getNumberOfValidBranches();
        }
        return numberOfValidBranches;
    }

    @Override
    public int getNumberOfValidLines() {
        return 1;
    }

    public boolean isCovered() {
        return this._hitCounter.get() > 0L && this.getNumberOfCoveredBranches() == this.getNumberOfValidBranches();
    }

    @Override
    public void merge(LineData lineData) {
        if (!this._className.equals(lineData._className) || this._lineNumber != lineData._lineNumber) {
            throw new IllegalArgumentException("Line data mismatch, left : " + this.toString() + ", right : " + lineData);
        }
        AtomicLong hitCounter = lineData._hitCounter;
        this._hitCounter.addAndGet(hitCounter.get());
        ConcurrentMap<Integer, JumpData> otherJumpDatas = lineData._jumpDatas;
        for (JumpData jumpData : otherJumpDatas.values()) {
            JumpData previousJumpData = this._jumpDatas.putIfAbsent(jumpData.getJumpNumber(), jumpData);
            if (previousJumpData == null) continue;
            previousJumpData.merge(jumpData);
        }
        ConcurrentMap<Integer, SwitchData> otherSwitchDatas = lineData._switchDatas;
        for (SwitchData switchData : otherSwitchDatas.values()) {
            SwitchData previousSwitchData = this._switchDatas.putIfAbsent(switchData.getSwitchNumber(), switchData);
            if (previousSwitchData == null) continue;
            previousSwitchData.merge(switchData);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{className=");
        sb.append(this._className);
        sb.append(", lineNumber=");
        sb.append(this._lineNumber);
        sb.append("}");
        return sb.toString();
    }

    public void touch() {
        this._hitCounter.incrementAndGet();
    }

    public void touchJump(int jumpNumber, boolean branch) {
        JumpData jumpData = (JumpData)this._jumpDatas.get(jumpNumber);
        if (jumpData == null) {
            throw new IllegalStateException("No instrument data for class " + this._className + " line " + this._lineNumber + " jump " + jumpNumber);
        }
        jumpData.touchBranch(branch);
    }

    public void touchSwitch(int switchNumber, int branch) {
        SwitchData switchData = (SwitchData)this._switchDatas.get(switchNumber);
        if (switchData == null) {
            throw new IllegalStateException("No instrument data for class " + this._className + " line " + this._lineNumber + " switch " + switchNumber);
        }
        switchData.touchBranch(branch);
    }
}

