/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.coveragedata;

import com.liferay.whip.coveragedata.BranchCoverageData;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

public class SwitchData
implements BranchCoverageData<SwitchData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _className;
    private final AtomicLongArray _hitCounterArray;
    private final int _lineNumber;
    private final int _switchNumber;

    public SwitchData(String className, int lineNumber, int switchNumber, int caseNumber) {
        this._className = className;
        this._lineNumber = lineNumber;
        this._switchNumber = switchNumber;
        this._hitCounterArray = new AtomicLongArray(caseNumber + 1);
    }

    @Override
    public double getBranchCoverageRate() {
        return (double)this.getNumberOfCoveredBranches() / (double)this.getNumberOfValidBranches();
    }

    @Override
    public int getNumberOfCoveredBranches() {
        int numberOfCoveredBranches = 0;
        for (int i = 0; i < this._hitCounterArray.length(); ++i) {
            if (this._hitCounterArray.get(i) <= 0L) continue;
            ++numberOfCoveredBranches;
        }
        return numberOfCoveredBranches;
    }

    @Override
    public int getNumberOfValidBranches() {
        return this._hitCounterArray.length();
    }

    public int getSwitchNumber() {
        return this._switchNumber;
    }

    @Override
    public void merge(SwitchData switchData) {
        AtomicLongArray hitCounterArray = switchData._hitCounterArray;
        if (!this._className.equals(switchData._className) || this._lineNumber != switchData._lineNumber || this._switchNumber != switchData._switchNumber || this._hitCounterArray.length() != hitCounterArray.length()) {
            throw new IllegalArgumentException("Switch data mismatch, left : " + this.toString() + ", right : " + switchData);
        }
        for (int i = 0; i < this._hitCounterArray.length(); ++i) {
            this._hitCounterArray.addAndGet(i, hitCounterArray.get(i));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{className=");
        sb.append(this._className);
        sb.append(", lineNumber=");
        sb.append(this._lineNumber);
        sb.append(", switchNumber=");
        sb.append(this._switchNumber);
        sb.append(", caseNumber=");
        sb.append(this._hitCounterArray.length());
        sb.append("}");
        return sb.toString();
    }

    public void touchBranch(int branch) {
        if (branch >= this._hitCounterArray.length()) {
            throw new IllegalStateException("No instrument data for class " + this._className + " line " + this._lineNumber + " switch " + this._switchNumber + " branch " + branch);
        }
        if (branch == -1) {
            branch = this._hitCounterArray.length() - 1;
        }
        this._hitCounterArray.incrementAndGet(branch);
    }
}

