/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.instrument;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class ContextAwareClassWriter
extends ClassWriter {
    public ContextAwareClassWriter(int flags) {
        super(flags);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(type2)) {
            return type1;
        }
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add(type1);
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(type2);
        while (true) {
            if ((type1 = this.getSuperName(type1)) != null) {
                if (list2.contains(type1)) {
                    return type1;
                }
                list1.add(type1);
            }
            if ((type2 = this.getSuperName(type2)) == null) continue;
            if (list1.contains(type2)) {
                return type2;
            }
            list2.add(type2);
        }
    }

    protected String getSuperName(String type) {
        if (type == null) {
            return null;
        }
        String resourceName = type.concat(".class");
        ClassLoader classLoader = ContextAwareClassWriter.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
            inputStream = classLoader.getResourceAsStream(resourceName);
        }
        if (inputStream == null) {
            throw new RuntimeException("Unable to locate class definition for " + type);
        }
        try {
            ClassReader classReader = new ClassReader(inputStream);
            String string = classReader.getSuperName();
            return string;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to parse class definition for " + type, ioException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

