/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.instrument;

import com.liferay.whip.coveragedata.ClassData;
import com.liferay.whip.instrument.BackwardCompatibleMethodNode;
import com.liferay.whip.instrument.SwitchHolder;
import com.liferay.whip.instrument.TouchMethodVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

public class OutlineMethodVisitor
extends MethodVisitor {
    private final ClassData _classData;
    private int _currentJump;
    private int _currentLine;
    private int _currentSwitch;
    private final String _desc;
    private final Set<Label> _jumpLabels = new HashSet<Label>();
    private final Map<Label, Integer> _lineLabels = new HashMap<Label, Integer>();
    private final MethodNode _methodNode;
    private final MethodVisitor _methodVisitor;
    private final String _name;
    private final Map<Label, SwitchHolder> _switchLabels = new HashMap<Label, SwitchHolder>();

    public OutlineMethodVisitor(ClassData classData, MethodVisitor methodVisitor, int access, String name, String desc, String signature, String[] exceptions) {
        super(327680, (MethodVisitor)new BackwardCompatibleMethodNode(access, name, desc, signature, exceptions));
        this._classData = classData;
        this._methodVisitor = methodVisitor;
        this._name = name;
        this._desc = desc;
        this._methodNode = (MethodNode)this.mv;
    }

    public void visitEnd() {
        super.visitEnd();
        MethodVisitor methodVisitor = this._methodVisitor;
        if (!this._lineLabels.isEmpty()) {
            methodVisitor = new TouchMethodVisitor(this._classData.getName(), this._methodNode, this._methodVisitor, this._jumpLabels, this._lineLabels, this._switchLabels);
        }
        this._methodNode.accept(methodVisitor);
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this._currentLine != 0 && opcode != 167 && opcode != 168) {
            this._classData.addLineJump(this._currentLine, this._currentJump++);
            this._jumpLabels.add(label);
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitLineNumber(int line, Label start) {
        this._currentLine = line;
        this._currentJump = 0;
        this._currentSwitch = 0;
        this._classData.addLine(this._name, this._desc, this._currentLine);
        this._lineLabels.put(start, line);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (this._currentLine != 0) {
            this._switchLabels.put(dflt, new SwitchHolder(this._currentLine, this._currentSwitch, -1));
            for (int i = 0; i < labels.length; ++i) {
                this._switchLabels.put(labels[i], new SwitchHolder(this._currentLine, this._currentSwitch, i));
            }
            this._classData.addLineSwitch(this._currentLine, this._currentSwitch++, keys);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (this._currentLine != 0) {
            this._switchLabels.put(dflt, new SwitchHolder(this._currentLine, this._currentSwitch, -1));
            for (int i = 0; i < labels.length; ++i) {
                this._switchLabels.put(labels[i], new SwitchHolder(this._currentLine, this._currentSwitch, i));
            }
            this._classData.addLineSwitch(this._currentLine, this._currentSwitch++, min, max);
        }
    }
}

