/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.whip.instrument;

import com.liferay.whip.coveragedata.TouchUtil;
import com.liferay.whip.instrument.JumpHolder;
import com.liferay.whip.instrument.SwitchHolder;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class TouchMethodVisitor
extends MethodVisitor {
    private static final String _TOUCH_UTIL_CLASS = Type.getInternalName(TouchUtil.class);
    private int _currentJump;
    private int _currentLine;
    private Label _endLabel;
    private final Set<Label> _jumpLabels;
    private JumpHolder _lastJump;
    private final Map<Label, Integer> _lineLabels;
    private final String _owner;
    private boolean _started;
    private Label _startLabel;
    private final Map<Label, SwitchHolder> _switchLabels;
    private final int _variableCount;
    private int _variableIndex;

    public TouchMethodVisitor(String owner, MethodNode methodNode, MethodVisitor methodVisitor, Set<Label> jumpLabels, Map<Label, Integer> lineLabels, Map<Label, SwitchHolder> switchLabels) {
        super(327680, methodVisitor);
        this._owner = owner;
        this._jumpLabels = jumpLabels;
        this._lineLabels = lineLabels;
        this._switchLabels = switchLabels;
        int variableCount = 0;
        if ((8 & methodNode.access) == 0) {
            ++variableCount;
        }
        for (Type type : Type.getArgumentTypes((String)methodNode.desc)) {
            variableCount += type.getSize();
        }
        this._variableCount = variableCount;
    }

    public void visitCode() {
        this._started = true;
        super.visitCode();
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this._touchBranch();
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitIincInsn(int var, int increment) {
        this._touchBranch();
        if (var >= this._variableCount) {
            var += 2;
        }
        this.mv.visitIincInsn(var, increment);
    }

    public void visitInsn(int opcode) {
        this._touchBranch();
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this._touchBranch();
        super.visitIntInsn(opcode, operand);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this._touchBranch();
        if (this._currentLine != 0 && opcode != 167 && opcode != 168) {
            this.mv.visitIntInsn(17, this._currentLine);
            this.mv.visitVarInsn(54, this._variableIndex);
            this.mv.visitIntInsn(17, this._currentJump);
            this.mv.visitVarInsn(54, this._variableIndex + 1);
            this._lastJump = new JumpHolder(this._currentLine, this._currentJump++);
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        Integer line;
        Label label1;
        if (this._started) {
            this._started = false;
            if (!this._jumpLabels.isEmpty()) {
                this._variableIndex = this._variableCount;
                this.mv.visitInsn(3);
                this.mv.visitVarInsn(54, this._variableIndex);
                this.mv.visitIntInsn(17, -1);
                this.mv.visitVarInsn(54, this._variableIndex + 1);
                this._startLabel = label;
            }
        }
        this._endLabel = label;
        super.visitLabel(label);
        if (this._jumpLabels.contains(label)) {
            if (this._lastJump != null) {
                label1 = this._lastJump();
                this._touchJump(false);
                Label label2 = new Label();
                this.mv.visitJumpInsn(167, label2);
                this.mv.visitLabel(label1);
                this.mv.visitVarInsn(21, this._variableIndex + 1);
                this.mv.visitJumpInsn(155, label2);
                this._touchJump(true);
                this.mv.visitLabel(label2);
            } else {
                this.mv.visitVarInsn(21, this._variableIndex + 1);
                label1 = new Label();
                this.mv.visitJumpInsn(155, label1);
                this._touchJump(true);
                this.mv.visitLabel(label1);
            }
        } else if (this._lastJump != null) {
            label1 = this._lastJump();
            this._touchJump(false);
            this.mv.visitLabel(label1);
        }
        this._lastJump = null;
        SwitchHolder switchHolder = this._switchLabels.get(label);
        if (switchHolder != null) {
            this._touchSwitch(switchHolder.getLineNumber(), switchHolder.getJumpNumber(), switchHolder.getBranch());
        }
        if ((line = this._lineLabels.get(label)) != null) {
            this.visitLineNumber(line, label);
        }
    }

    public void visitLdcInsn(Object cst) {
        this._touchBranch();
        super.visitLdcInsn(cst);
    }

    public void visitLineNumber(int line, Label start) {
        this._currentLine = line;
        this._currentJump = 0;
        this.mv.visitLdcInsn((Object)this._owner);
        this.mv.visitIntInsn(17, line);
        this.mv.visitMethodInsn(184, _TOUCH_UTIL_CLASS, "touch", "(Ljava/lang/String;I)V", false);
        super.visitLineNumber(line, start);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index >= this._variableCount) {
            index += 2;
        }
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this._touchBranch();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (!this._jumpLabels.isEmpty()) {
            this.mv.visitLocalVariable("__whip__line__number__", "I", null, this._startLabel, this._endLabel, this._variableIndex);
            this.mv.visitLocalVariable("__whip__branch__number__", "I", null, this._startLabel, this._endLabel, this._variableIndex + 1);
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.visitMethodInsn(opcode, owner, name, desc, false);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this._touchBranch();
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this._touchBranch();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this._touchBranch();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this._touchBranch();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this._touchBranch();
        super.visitTypeInsn(opcode, desc);
    }

    public void visitVarInsn(int opcode, int var) {
        this._touchBranch();
        if (var >= this._variableCount) {
            var += 2;
        }
        this.mv.visitVarInsn(opcode, var);
    }

    private Label _lastJump() {
        this.mv.visitVarInsn(21, this._variableIndex);
        this.mv.visitIntInsn(17, this._lastJump.getLineNumber());
        Label label = new Label();
        this.mv.visitJumpInsn(160, label);
        this.mv.visitVarInsn(21, this._variableIndex + 1);
        this.mv.visitIntInsn(17, this._lastJump.getJumpNumber());
        this.mv.visitJumpInsn(160, label);
        return label;
    }

    private void _touchBranch() {
        if (this._lastJump != null) {
            this._lastJump = null;
            this._touchJump(false);
        }
    }

    private void _touchJump(boolean branch) {
        this.mv.visitLdcInsn((Object)this._owner);
        this.mv.visitVarInsn(21, this._variableIndex);
        this.mv.visitVarInsn(21, this._variableIndex + 1);
        if (branch) {
            this.mv.visitInsn(3);
        } else {
            this.mv.visitInsn(4);
        }
        this.mv.visitMethodInsn(184, _TOUCH_UTIL_CLASS, "touchJump", "(Ljava/lang/String;IIZ)V", false);
        this.mv.visitIntInsn(17, -1);
        this.mv.visitVarInsn(54, this._variableIndex + 1);
    }

    private void _touchSwitch(int lineNumber, int switchNumber, int branch) {
        this.mv.visitLdcInsn((Object)this._owner);
        this.mv.visitIntInsn(17, lineNumber);
        this.mv.visitIntInsn(17, switchNumber);
        this.mv.visitIntInsn(17, branch);
        this.mv.visitMethodInsn(184, _TOUCH_UTIL_CLASS, "touchSwitch", "(Ljava/lang/String;III)V", false);
    }
}

